<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
 XSLT stylesheet to transform Qsieve-XML-statusreports to HTML
 written 2004-07-21 by Thorsten Reinecke
 last change: 2004-09-04 by Thorsten Reinecke
-->

<xsl:template match="/">
 <HTML>
 <HEAD>
  <TITLE>Qsieve Factorization Status Pages</TITLE>
 </HEAD>
 <BODY style="background-color: black; color: white;">
 <xsl:apply-templates />
 </BODY>
 </HTML>
</xsl:template>

<xsl:template match="LOGFILE">
 <H1> Log of latest factorizations </H1>
 <xsl:apply-templates />
 <br/><hr/>
</xsl:template>

<xsl:template match="QSIEVESTATISTICS">
 <H1> Status of factorization </H1>
 <xsl:apply-templates />
 <br/><hr/>
 Faktorisierungsprogramm qsieve-<xsl:value-of select="@VERSION" />, <xsl:value-of select="@TIME" />
</xsl:template>

<xsl:template match="NUMBER">
 <H2> Number to factorize: </H2>
 <xsl:apply-templates />
</xsl:template>

<xsl:template match="NUMBERSECTION">
 <H2> Number to factorize: </H2>
 <xsl:apply-templates />
</xsl:template>

<xsl:template match="ITEM">
 <xsl:variable name="content" select="@CONTENT" />
 <xsl:value-of select="$content"/>
 <xsl:apply-templates />
 <br/>
</xsl:template>


<xsl:template match="FACTOR">
 <tr><td>
 <xsl:apply-templates />
 </td></tr>
</xsl:template>


<xsl:template match="TABLE">

 <xsl:variable name="content" select="@CONTENT" />
 <xsl:choose>
  <xsl:when test="$content='NETCLIENTS'" >
  <H2>Status of connected net-clients:</H2>
  <table border="2" style="width: 100%;"> <tbody align="center">
  <tr>
  <td>client</td>
  <td>first connect</td>
  <td>last connect</td>
  <td>static relations</td>
  <td>SLP relations</td>
  <td>DLP relations</td>
  <td>rate</td>
  </tr>
  <xsl:apply-templates />
  </tbody> </table>
 </xsl:when>
 <xsl:when test="$content='FACTORS'">
  <H2>Recently found factors:</H2>
  <table border="0" > <tbody align="center">
  <xsl:apply-templates />
  </tbody> </table>
 </xsl:when>
 <xsl:when test="string-length($content) &gt; 0">
  <H2>Table of <xsl:value-of select="$content"/>:</H2>
  <table border="1" > <tbody align="center">
  <xsl:apply-templates />
  </tbody> </table>
 </xsl:when>

 <xsl:otherwise>
  <table border="1" style="width: 100%;"> <tbody>
  <xsl:apply-templates />
  </tbody> </table>
 </xsl:otherwise>

</xsl:choose>
</xsl:template>


<xsl:template match="tr">
 <tr>
 <xsl:apply-templates />
 </tr>
</xsl:template>

<xsl:template match="td">
 <td>
 <xsl:apply-templates />
 </td>
</xsl:template>

<xsl:template match="TIMESTAMP">
 <xsl:call-template name="timestamp-to-date">
   <xsl:with-param name="value" select="@TIME"/>
 </xsl:call-template>
 <xsl:apply-templates />
</xsl:template>

<xsl:template match="DIFFTIME">

 <xsl:variable name="tmp" select="@TIME"/>
 <xsl:choose>
  <xsl:when test="$tmp &gt; 2*24*60*60">
   <xsl:value-of select='format-number($tmp div (24*60*60),"#.00")' />  days
  </xsl:when>
  <xsl:when test="$tmp &gt; 2*60*60">
   <xsl:value-of select='format-number($tmp div (60*60),"#.00")' /> hours
  </xsl:when>
  <xsl:when test="$tmp &gt; 2*60">
   <xsl:value-of select='format-number($tmp div 60,"#.00")' /> min
  </xsl:when>
  <xsl:otherwise>
   <xsl:value-of select="$tmp" /> sec
  </xsl:otherwise>
 </xsl:choose>

 <xsl:apply-templates />
</xsl:template>


<xsl:template match="NETCLIENT">
 <tr>
 <td><xsl:value-of select="@HOSTNAME" /> </td>
 <td><xsl:value-of select="@FIRSTCONNECT" /> </td>
 <td><xsl:value-of select="@LASTCONNECT" /> </td>
 <td><xsl:value-of select="@STATICRELATIONS" /> </td>
 <td><xsl:value-of select="@DYNAMICRELATIONS" /> </td>
 <td><xsl:value-of select="@DLPRELATIONS" /> </td>
 <td><xsl:value-of select="@PERCENTAGE" /> </td>
 </tr>
 <xsl:apply-templates />
</xsl:template>


<xsl:template match="STATUSINFO">
 <H2> Server status (total): </H2>
 <table border="0"><tbody>
 <xsl:apply-templates />
 </tbody></table>
</xsl:template>

<xsl:template match="RELFOUND">
 <tr><td>static relations found so far:</td><td>
 <xsl:apply-templates />
 </td></tr>
</xsl:template>

<xsl:template match="RELDISTRIBUTION">
 with distribution {
 <xsl:apply-templates />
 }
</xsl:template>

<xsl:template match="RELTOTAL">
 <tr><td>size of factorbase:</td><td> 
 <xsl:apply-templates />
 </td></tr>
</xsl:template>

<xsl:template match="SLPFOUND">
 <tr><td>dynamic relations actively found:</td><td>
 <xsl:apply-templates />
 </td></tr>
</xsl:template>

<xsl:template match="SLPTOTAL">
 <tr><td>single large primes (total):</td><td>
 <xsl:apply-templates />
 </td></tr>
</xsl:template>

<xsl:template match="DLPTOTAL">
 <tr><td>double large primes found so far:</td><td>
 <xsl:apply-templates />
 </td></tr>
</xsl:template>

<xsl:template match="DLP2SLP">
 <tr><td>DLP splitted to SLP relations:</td><td>
 <xsl:apply-templates />
 </td></tr>
</xsl:template>

<xsl:template match="DLP2STATIC">
 <tr><td>DLP special hits (eg. quadratic DLP):</td><td>
 <xsl:apply-templates />
 </td></tr>
</xsl:template>

<xsl:template match="DLP2CYCLE">
 <tr><td>DLP cycle splits to static relations:</td><td>
 <xsl:apply-templates />
 </td></tr>
</xsl:template>

<xsl:template match="PERCENTAGEDONE">
 <tr><td>done:</td><td>
 <xsl:apply-templates />
 </td></tr>
</xsl:template>



<xsl:template name="timestamp-to-date">
 <xsl:param name="value" select="number(0)"/>

 <xsl:variable name="days" select="floor($value div (24*60*60))" />
 <xsl:variable name="YYYY" select="1970+floor(($days +2*365+1) div 365.25-2)" />
 <xsl:variable name="h1" select="($days + 2*365 +1) mod (4*365+1)" />
 <xsl:variable name="h2" select="($h1 -1) mod 365" />

 <xsl:value-of select="$YYYY" />
 <xsl:choose>
  <xsl:when test="$h1 &lt;  31">-01-<xsl:value-of select='format-number($h1     +1,"00")' /></xsl:when>
  <xsl:when test="$h1 &lt;  60">-02-<xsl:value-of select='format-number($h1 - 31+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt; 333">-12-<xsl:value-of select='format-number($h2 -334+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt; 303">-11-<xsl:value-of select='format-number($h2 -304+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt; 272">-10-<xsl:value-of select='format-number($h2 -273+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt; 242">-09-<xsl:value-of select='format-number($h2 -243+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt; 211">-08-<xsl:value-of select='format-number($h2 -212+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt; 180">-07-<xsl:value-of select='format-number($h2 -181+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt; 150">-06-<xsl:value-of select='format-number($h2 -151+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt; 119">-05-<xsl:value-of select='format-number($h2 -120+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt;  89">-04-<xsl:value-of select='format-number($h2 - 90+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt;  58">-03-<xsl:value-of select='format-number($h2 - 59+1,"00")' /></xsl:when>
  <xsl:when test="$h2 &gt;  30">-02-<xsl:value-of select='format-number($h2 - 31+1,"00")' /></xsl:when>
  <xsl:otherwise>-01-<xsl:value-of select='format-number($h2 + 1,"00")' /></xsl:otherwise>
 </xsl:choose>

 <xsl:variable name="ss" select='format-number($value mod 60,"00")' />
 <xsl:variable name="mm" select='format-number(floor($value mod (60*60) div 60),"00")' />
 <xsl:variable name="hh" select='format-number(floor($value mod (24*60*60) div (60*60)),"00")' />

 <xsl:value-of select="concat(' ',$hh,':',$mm,':',$ss)" />
</xsl:template>


</xsl:stylesheet>
