<?php
 // we want to access session variables!
 session_start();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
  <meta http-equiv="Content-Type" content="text/html;charset=iso-8859-1" >
  <link rel="icon" type="image/x-icon" href="qsieve.ico">
  <link rel="shortcut icon" type="image/x-icon" href="qsieve.ico">
  <TITLE>Qsieve: Status of current factorization</TITLE>
  <STYLE type="text/css">
   <!--
     BODY {background-color: black; color: white}
     .expanded { color:white; text-decoration:none; }
     .expanded_over { color:white; text-decoration:none; }
     .collapsed { color: #9a00fc; text-decoration:none; }
     .collapsed_over { color:#9a50fc; text-decoration:none; }
     a:link,a:visited,a:active { color:white; text-decoration:underline; }
     a:hover { color:#9a50fc; text-decoration:none; }
     table { border-collapse: collapse; }
     tr.style1 { color: #ffffcc; background-color: #19002a; }
     tr.style2 { color: #ffffcc; background-color: #1e1032; }
    -->
  </STYLE>

  <script src="qsieve-status.js" type="text/javascript" language="javascript">
  </script> 

</HEAD>

<BODY>

<img align="middle" alt="Qsieve Logo &nbsp;"src="qsieve.png">

<?php

// a php4 script which connects to the qsieve XML status port
// and prints the status information
// written 2004-07-21 by Thorsten Reinecke
// last change: 2004-11-18 by Thorsten Reinecke

$host = "localhost"; // host on which qsieve server is running
$port = 12370; // qsieve XML status port
$file = "status.xml"; // if this connection fails, we use the content of this file instead


$map_array_S = array(
"LOGFILE" => "<H1> Log of latest factorizations </H1>",
"QSIEVESTATISTICS" => "<H1> Status of current factorization </H1>",
"NUMBERSECTION" => "<div><H2> Number to factorize </H2><div>",
"NUMBER" => "<div><H2> Number to factorize </H2><div>",
"ITEM" => "",
"TIMESTAMP" => "",
"DIFFTIME" => "",
"FACTOR" => "<tr><td>",
"DIGITS" => " (",
"TABLE" => "<div> <table border=\"1\" style=\"width: 100%;\"> <tbody>",
"TR" => "<tr>",
"TD" => "<td>",
"STATUSINFO" => "<div><H2> Current server status (total) </H2>\n<table border=\"0\"><tbody>",
"RELFOUND" => "<tr class=style2><td>static relations found so far:</td><td>",
"RELDISTRIBUTION" => " with distribution {",
"RELTOTAL" => "<tr class=style1><td>size of factorbase:</td><td> ",
"SLPFOUND" => "<tr class=style2><td>dynamic relations actively found:</td><td>",
"SLPTOTAL" => "<tr class=style1><td>single large primes (total):</td><td>",
"DLPTOTAL" => "<tr class=style2><td>double large primes found so far:</td><td>",
"DLP2SLP" => "<tr class=style1><td>DLP splitted to SLP relations:</td><td>",
"DLP2STATIC" => "<tr class=style2><td>DLP special hits (eg. quadratic DLP):</td><td>",
"DLP2CYCLE" => "<tr class=style1><td>DLP cycle splits to static relations:</td><td>",
"PERCENTAGEDONE" => "<tr class=style2><td>done:</td><td>"
);

$map_array_E = array(
"QSIEVESTATISTICS" => "<br><hr>".strftime("%Y-%m-%d, %X (%Z)", time())." <br>",
"NUMBERSECTION" => "</div></div>",
"NUMBER" => "</div></div>",
"ITEM" => "<br>",
"TIMESTAMP" => "",
"DIFFTIME" => "",
"FACTOR" => "</td></tr>",
"DIGITS" => ") ",
"TABLE" => "</tbody> </table> </div>\n",
"TR" => "</tr>",
"TD" => "</td>",
"NETCLIENT" => "</tr>",
"STATUSINFO" => "</tbody></table></div>",
"RELFOUND" => "</td></tr>",
"RELDISTRIBUTION" => "}",
"RELTOTAL" => "</td></tr>",
"SLPFOUND" => "</td></tr>",
"SLPTOTAL" => "</td></tr>",
"DLPTOTAL" => "</td></tr>",
"DLP2SLP" => "</td></tr>",
"DLP2STATIC" => "</td></tr>",
"DLP2CYCLE" => "</td></tr>",
"PERCENTAGEDONE" => "</td></tr>"
);


$Time = strftime("%Y-%m-%d, %X (%Z)", time());
$Version = "unknown";
$JSActionString = "";
$created_id_counter = 0;
$JavaScript_enabled = false;
$TableOfProgress = false;
$is_Logfile = false;
$TofP = "";
$TofPi = 0;
$TofPc = 0;



function createId(&$name)
{
 global $created_id_counter;
 ++$created_id_counter;
 $tmp = isset($name) ? $name : 'empty';
 $item = str_replace(" ","",$tmp).$created_id_counter;
 return $item;
}

function addCookieAction($item)
{
  global $JSActionString;
  $JSActionString .= "if (GetCookieValue('$item')==\"expanded\") expand('$item'); else collapse('$item');\n";
}

function DivAction($item)
{
  echo "<div id=\"$item\" style=\"cursor:pointer;\" ";
  echo "OnClick=\"javascript:collapse_and_expand('$item');javascript:my_MouseOver('$item');\" ";
  echo "OnMouseOver=\"javascript:my_MouseOver('$item')\" ";
  echo "OnMouseOut=\"javascript:my_MouseOut('$item')\" >\n";
}

function startElement($parser, $name, $attribs)
{
  global $map_array_S;
  global $Time;
  global $Version;
  global $JSActionString;
  global $JavaScript_enabled;
  global $current_item_obj;
  global $TableOfProgress;
  global $TofP, $TofPi, $TofPc;

  switch ($name)
   {
     case "TD":
       if ($TableOfProgress)
        {
          // Index of array TofP; quick & dirty!
          ++$TofPi;
        }
        echo "<td>";
      break;

     case "TR":
       {
         static $style=1;
         echo "<tr class=style".($style+1).">";
         $style=($style+1)%2;
       }
      break;

     case "QSIEVESTATISTICS":
       $Time=$attribs['TIME'];
       $Version=$attribs['VERSION'];
       static $nr = 1;
       global $is_Logfile;
       if ($is_Logfile)
        {
          echo "<br><hr>";
          echo "<H1> Status of factorization #$nr</H1>\n";
          ++$nr;
        }
       else
        if (isset($map_array_S[$name])) echo "$map_array_S[$name]";
        else echo " ($name start) ";
      break;

     case "TABLE":
      if ($attribs['CONTENT'] == "FACTORS")
       {
         $item=createId($attribs['CONTENT']); $item_title=$item."title"; $item_child = $item."child";
         addCookieAction($item);
         DivAction($item);
         echo "<H2 id=\"$item_title\"><img name=$item_title alt=\"\" align=\"left\" src=\"arrow-down.png\">Recently found factors</H2>\n";
         echo "<table id=\"$item_child\" border=\"0\"> <tbody align=\"center\">";
         break;
       }
      if ($attribs['CONTENT'] == "progress")
       {
         $item=createId($attribs['CONTENT']); $item_title=$item."title"; $item_child = $item."child";
         addCookieAction($item);
         DivAction($item);
         echo "<H2 id=\"$item_title\"><img name=$item_title alt=\"\" align=\"left\" src=\"arrow-down.png\"> Table of ". $attribs['CONTENT']."</H2>\n";
         echo "<div id=\"$item_child\">\n";
         ++$TofPc; $TofP="DIAGRAMM1_".$TofPc;
         $_SESSION[$TofP]=array();
         $TofPi=0;

         if ($TofPc>1)
          echo "<img id=\"DIAGRAMM1_".$TofPc."\" border=\"off\" alt=\"diagramm1\" align=\"middle\" src=\"diagramm1.php?nr=$TofPc\"><p>\n";
         else
          // I haven't discovered yet why the above doesn't work in conjunction with IE,
          // so this is only a quick hack for providing at least the first image...
          echo "<img id=\"DIAGRAMM1_".$TofPc."\" border=\"off\" alt=\"diagramm1\" align=\"middle\" src=\"diagramm1.php\"><p>\n";

         echo "<table border=\"1\" cellpadding=\"4\"> <tbody align=\"center\">";
         $TableOfProgress=true;
         break;
       }
      if ($attribs['CONTENT'] == "NETCLIENTS")
       {
         $item=createId($attribs['CONTENT']); $item_title=$item."title"; $item_child = $item."child";
         $current_item_obj = $item."obj";
         addCookieAction($item);
         // DivAction($item); // not used here

         echo "<H2 id=\"$item_title\"";
         echo " style=\"cursor:pointer;\" ";
         echo "OnClick=\"javascript:collapse_and_expand('$item');javascript:my_MouseOver('$item');\" ";
         echo "OnMouseOver=\"javascript:my_MouseOver('$item')\" ";
         echo "OnMouseOut=\"javascript:my_MouseOut('$item')\" >\n";
         echo "<img name=$item_title alt=\"\" align=\"left\" src=\"arrow-down.png\">Status of connected net-clients</H2>\n";

         echo "<div id=\"$item\" >\n";
         echo "<div id=\"$item_child\" >\n";
         echo "This table can be reduced by stepwise <a href=\"javascript:$current_item_obj.AccumulateSubnets()\">collapsing subnets</a>";
         echo " and also re-expanded by <a href=\"javascript:$current_item_obj.AccumulateSubnets_undo()\">undo collapsing subnets</a>.\n";
         $JSActionString .= "var d=parseInt(GetCookieValue('collapse_depth')); if (d>0) $current_item_obj.AccumulateSubnets(d);\n";

         echo "<H3 id=\"".$current_item_obj."NCH3\">Status of connected net-clients sorted by default criteria</H3>\n";
         echo "<table id=\"".$current_item_obj."NCCHANGEME\" border=\"2\" style=\"width: 100%;\"> <tbody align=\"center\">";
         echo "<tr>";
         echo "<td><a href=\"javascript:$current_item_obj.ChangeTable('client')\">client</a></td> ";
         echo "<td><a href=\"javascript:$current_item_obj.ChangeTable('first connect')\">first connect</a></td> ";
         echo "<td><a href=\"javascript:$current_item_obj.ChangeTable('last connect')\">last connect</a></td> ";
         echo "<td><a href=\"javascript:$current_item_obj.ChangeTable('static relations')\">static relations</a></td> ";
         echo "<td><a href=\"javascript:$current_item_obj.ChangeTable('SLP relations')\">SLP relations</a></td> ";
         echo "<td><a href=\"javascript:$current_item_obj.ChangeTable('DLP relations')\">DLP relations</a></td> ";
         echo "<td><a href=\"javascript:$current_item_obj.ChangeTable('rate')\">rate</a></td> ";
         echo "</tr>";
         echo "</tbody></table>\n";
         echo "</div></div>\n";
         echo "<script type=\"text/javascript\" language=\"javascript\">\n";
         echo "<!--\n";
         $JavaScript_enabled=true;
         echo "$current_item_obj = new TableOfNetClients(\"$current_item_obj\")\n";
         break;
       }
      if (isset($attribs['CONTENT']))
       {
         $item=createId($attribs['CONTENT']); $item_title=$item."title"; $item_child = $item."child";
         addCookieAction($item);
         DivAction($item);
         echo "<H2 id=\"$item_title\"><img name=$item_title alt=\"\" align=\"left\" src=\"arrow-down.png\"> Table of ". $attribs['CONTENT']."</H2>\n";
         echo "<table id=\"$item_child\" border=\"1\"> <tbody align=\"center\">";
         break;
       }
      if (isset($map_array_S[$name])) echo "$map_array_S[$name]";
      else echo " ($name start) ";
      break;

     case "NETCLIENT":
       echo "$current_item_obj.push(new Array(\"$attribs[HOSTNAME]\",\"$attribs[FIRSTCONNECT]\",\"$attribs[LASTCONNECT]\",\"$attribs[STATICRELATIONS]\",\"$attribs[DYNAMICRELATIONS]\",\"$attribs[DLPRELATIONS]\",\"$attribs[PERCENTAGE]\"));";
      break;

     case "NUMBERSECTION":
       {
         $item = createId($attribs['CONTENT']); $item_title=$item."title"; $item_child = $item."child";
         addCookieAction($item);
         DivAction($item);
         echo "<H2 id=\"$item_title\"><img name=$item_title alt=\"\" align=\"left\" src=\"arrow-down.png\"> Number to factorize </H2>\n";
         echo "<div id=\"$item_child\">";
         break;
       }

     case "ITEM":
       {
         if (isset($attribs['CONTENT'])) echo $attribs['CONTENT'];
         break;
       }

     case "STATUSINFO":
       {
         $item = createId($attribs['CONTENT']); $item_title=$item."title"; $item_child = $item."child";
         addCookieAction($item);
         DivAction($item);
         echo "<H2 id=\"$item_title\"><img name=$item_title alt=\"\" align=\"left\" src=\"arrow-down.png\"> Current server status (total) </H2>\n";
         echo "<table id=\"$item_child\" border=\"0\" cellpadding=\"2\"><tbody>";
         break;
       }

     case "TIMESTAMP":
      {
        if (isset($attribs['TIME']))
         {
           $tmp= (int) $attribs['TIME'];
           echo strftime("%Y-%m-%d, %X (%Z)", $tmp);
           if ($TableOfProgress) $_SESSION[$TofP][$TofPi]=$tmp;
         }
        break;
      }

     case "DIFFTIME":
      {
        $tmp = isset($attribs['TIME']) ? (int) $attribs['TIME'] : 0;
        if ($tmp > (2*60*60*24))
         echo number_format($tmp/(60*60*24),2) . " days";
        else if ($tmp > (2*60*60))
         echo number_format($tmp/(60*60),2) . " hours";
        else if ($tmp > 2*60)
         echo number_format($tmp/60,2) . " min";
        else echo $tmp . " sec";
        break;
      }

     case "LOGFILE":
      {
        global $is_Logfile;
        $is_Logfile=true;
        if (isset($map_array_S[$name])) echo "$map_array_S[$name]";
        else echo " ($name start) ";
        break;
      }

     default:
      if (isset($map_array_S[$name])) echo "$map_array_S[$name]";
      else echo " ($name start) ";
   }
}

function endElement($parser, $name)
{
  global $map_array_E;
  global $Time;
  global $Version;
  global $JavaScript_enabled;
  global $current_item_obj;
  global $TableOfProgress;
  global $TofP, $TofPi, $TofPc;

  switch ($name)
   {
     case "QSIEVESTATISTICS":
       global $is_Logfile;
       if ($is_Logfile) echo "\n<br>"; else echo "\n<br><hr>";
       echo "Faktorisierungsprogramm qsieve-".$Version.", ".$Time;
       echo "<br>";
      break;
 
     case "NETCLIENT":
      break;

     case "TABLE":
      if ($JavaScript_enabled)
       {
         // disable JavaScript block
         $JavaScript_enabled=false;
         echo "$current_item_obj.WriteTable('client');\n";
         echo "// -->\n";
         echo "</script>\n";
         break;
       }
      if ($TableOfProgress)
       {
         $TableOfProgress=false;
         if (isset($map_array_E[$name]))
          {
           echo "$map_array_E[$name]";
          } else echo " ($name end) <br>";
         echo "</div>";
         break;
       }

     default:
      if (isset($map_array_E[$name]))
       {
        echo "$map_array_E[$name]";
       } else echo " ($name end) <br>";
   }
}

function characterData($parser, $data)
{
  global $TableOfProgress;
  global $TofP, $TofPi;

  if ($TableOfProgress)
   {
     $_SESSION[$TofP][$TofPi]=$data;
   }
  echo $data;
}


$xml_parser = xml_parser_create();
xml_set_element_handler($xml_parser, "startElement", "endElement");
xml_set_character_data_handler($xml_parser, "characterData");


if (!($fp = fsockopen($host, $port, $errno, $errstr, 30)))
 {
   echo "<small>\n";
   echo "<br>Could not connetct to qsieve XML status server\n";
   echo "<br>reason: $errstr ($errno)\n";
   echo "</small>\n";
   if (!($fp = fopen($file, "r")))
    {
      echo "<br>No statistical information available<br>\n";
      die("failed to access qsieve XML status information");
    }
}


while ($data = fread($fp, 4096))
{
   if (!xml_parse($xml_parser, $data, feof($fp)))
    {
      die(sprintf("XML error: %s at line %d",
                   xml_error_string(xml_get_error_code($xml_parser)),
                   xml_get_current_line_number($xml_parser)));
    }
}

fclose($fp);
xml_parser_free($xml_parser);

//for ($i=0; $i<count($TofP); $i++) echo "$i ... $TofP[$i] <br>\n";


// now follows the generation of some JavaScript code for
// collapsing or expanding the view of objects (tables, etc.)
echo "\n\n";
echo "<script type=\"text/javascript\" language=\"javascript\">\n";
echo $JSActionString;
// if we want auto-update, enable this:
//echo "setInterval('my_update();',5*60*1000);\n";
echo "</script>\n";
echo "\n";

?>
<table border="0" width="100%" align="center"><tr>
<td><small>&copy;2004 Thorsten Reinecke</small></td><td>
<img border="off" name="update" alt="update" align="right" src="update.png"
 OnMouseOver="document.images['update'].src='update2.png'"
 OnMouseOut="document.images['update'].src='update.png'"
 OnClick="javascript:my_update()" >
<img border="off" name="about" alt="about" align="right" src="about.png"
 OnMouseOver="document.images['about'].src='about2.png'"
 OnMouseOut="document.images['about'].src='about.png'"
 OnClick="javascript:location.href='http://www.thorstenreinecke.de/qsieve/'" >
</td></tr></table>
</BODY>
</HTML>
