// --------------------------------------------------------------------------
// JavaScript helper functions written by Thorsten Reinecke, 2004-08, 2004-11
// --------------------------------------------------------------------------

// get Cookie value for given id
function GetCookieValue(id)
 {
   var value = "";
   if(document.cookie)
    {
      var s = document.cookie.indexOf(id+"=");
      if (s<0) return value;
      s = s + id.length + 1;
      var value = document.cookie.substring(s,document.cookie.length);
      if (value.indexOf(";")>=0) value = value.substring(0,value.indexOf(";"));
    }
   return value;
 }

// store Cookie with value under the given id
function SetCookieValue(id, value)
 {
   document.cookie = id+"="+value+";";
 }


var collapsed_items = new Array();

// ----------------------------------------------------
// collapse a (menu-)object, semantic:
// <div id='ID'> <div id='IDtitle'/> <div id='IDchild'/> <\/div>
// collapse('ID') will
//      a) set a cookie ID="collapsed"
//      b) take some collapse-actions with IDtitle
//      c) remove IDchild from ID
// IDtitle need not to be necessarily a child of ID. 
// ----------------------------------------------------
function collapse(myid)
 {
   SetCookieValue(myid,"collapsed");
   if (s=document.getElementById(myid+"child"))
    {
      var h,t;
      h=document.getElementById(myid);
      if (t=document.getElementById(myid+"title")) t.className="collapsed";
      if (t=document.images[myid+"title"]) t.src="arrow-right.png";
      collapsed_items[myid]=h.removeChild(s);
    }
 }

// -------------------------------------------------------------
// expand a (menu-)object, semantic:
// <div id='ID'> <div id='IDtitle'/> <div id='IDchild'/> <\/div>
// expand('ID') will
//      a) set a cookie ID="expanded"
//      b) take some expand-actions with IDtitle
//      c) append IDchild to ID
// IDtitle need not to be necessarily a child of ID. 
// -------------------------------------------------------------
function expand(myid)
 {
   SetCookieValue(myid,"expanded");
   var t;
   if (t=document.getElementById(myid+"title")) t.className="expanded";
   if (t=document.images[myid+"title"]) t.src="arrow-down.png";
   if (!document.getElementById(myid+"child"))
    {
      var h=document.getElementById(myid);
      h.appendChild(collapsed_items[myid]);
      delete(collapsed_items[myid]);
    }
 }

// toggle between collapsed and expanded
function collapse_and_expand(myid)
 {
   var s=document.getElementById(myid+"child");
   if (s) collapse(myid); else expand(myid);
 }


function my_MouseOut(myid)
 {
   var t,p;
   if (t=document.getElementById(myid+"title")) with (t)
    {
      if (className=="expanded_over")
       {
         className="expanded";
         if (p=document.images[myid+"title"]) p.src="arrow-down.png";
       }
      if (className=="collapsed_over")
       {
         className="collapsed";
         if (p=document.images[myid+"title"]) p.src="arrow-right.png";
       }
    }
 }

var focused_id;

function my_MouseOver(myid)
 {
   var t,p;
   if (t=document.getElementById(myid+"title")) with (t)
    {
      my_MouseOut(focused_id); focused_id=myid;
      if (className=="expanded")
       {
         className="expanded_over";
         if (p=document.images[myid+"title"]) p.src="arrow2-down.png";
       }
      if (className=="collapsed")
       {
         className="collapsed_over";
         if (p=document.images[myid+"title"]) p.src="arrow2-right.png";
       }
    }
 }


function my_update()
 {
   // update the cookie settings and reload page
   location.reload();
 }


function CompareClient(a,b)
 {
   if (a[0]<b[0]) return -1;
   if (a[0]>b[0]) return 1;
   return 0;
 }

function eval_month(m)
 {
   switch (m.substr(0,3).toUpperCase())
    {
      case "JAN" : return 1;
      case "FEB" : return 2;
      case "MAR" : return 3;
      case "APR" : return 4;
      case "MAY" : return 5;
      case "JUN" : return 6;
      case "JUL" : return 7;
      case "AUG" : return 8;
      case "SEP" : return 9;
      case "OCT" : return 10;
      case "NOV" : return 11;
      case "DEC" : return 12;
      default:
        //alert(m.substr(0,3).toUpperCase());
        return 0; // unknown!
    }
 };

function compare_month(a,b)
 {
   var am=eval_month(a);
   var bm=eval_month(b);
   if (Math.abs(am-bm)>=6) return bm-am; // window of 6 month
   return am-bm;
 }

function CompareFirstConnect(a,b)
 {
   var cm=compare_month(a[1],b[1]);
   if (cm!=0) return cm;
   if (a[1]<b[1]) return -1;
   if (a[1]>b[1]) return 1;
   return 0;
 }

function CompareLastConnect(a,b)
 {
   var cm=compare_month(a[2],b[2]);
   if (cm!=0) return -cm;
   if (a[2]>b[2]) return -1;
   if (a[2]<b[2]) return 1;
   return 0;
 }

function CompareStaticRelations(a,b)
 {
   return b[3]-a[3];
 }

function CompareSLPRelations(a,b)
 {
   return b[4]-a[4];
 }

function CompareDLPRelations(a,b)
 {
   return b[5]-a[5];
 }

function CompareRate(a,b)
 {
   return parseFloat(b[6])-parseFloat(a[6]);
 }

function MyReplace(id,text)
 {
   var p = document.getElementById(id).firstChild;
   p.replaceData(0,p.nodeValue.length,text);
 }


// a class
function TableOfNetClients(myName)
 {
   this.Name = myName;
   this.NetClientsArray = new Array();
   this.NetClientsArray_orig = new Array();
   this.sorted_by = "";
   this.collapse_depth = 0;
   this.removedChildren = new Array();

   this.push = TableOfNetClients_push;
   this.sort = TableOfNetClients_sort;
   this.WriteTable = TableOfNetClients_WriteTable;
   this.ChangeTable = TableOfNetClients_ChangeTable;
   this.AccumulateSubnets = TableOfNetClients_AccumulateSubnets;
   this.AccumulateSubnets_undo = TableOfNetClients_AccumulateSubnets_undo;
 }

function TableOfNetClients_push(element)
 {
   this.NetClientsArray.push(element);
   this.NetClientsArray_orig.push(element.slice(0,element.length)); // cloned element, not just a reference!
 }

function TableOfNetClients_sort(sort_by)
 {
   switch (sort_by)
    {
      case "client": this.NetClientsArray.sort(CompareClient); break;
      case "first connect": this.NetClientsArray.sort(CompareFirstConnect); break;
      case "last connect": this.NetClientsArray.sort(CompareLastConnect); break;
      case "static relations": this.NetClientsArray.sort(CompareStaticRelations); break;
      case "SLP relations": this.NetClientsArray.sort(CompareSLPRelations); break;
      case "DLP relations": this.NetClientsArray.sort(CompareDLPRelations); break;
      case "rate": this.NetClientsArray.sort(CompareRate); break;
      default: alert("Shame on you! You encountered an ERROR!"); return;
    }
   this.sorted_by=sort_by;
 }  

function TableOfNetClients_WriteTable(sort_by)
 {
   with (document)
    {
      this.sort(sort_by);
      if (sort_by!="") MyReplace(this.Name+"NCH3","Status of connected net-clients sorted by "+sort_by);

      writeln("<table id=\""+this.Name+"NCTABLE\" border=\"1\" cellpadding=\"2\" style=\"width: 100%;\"> <tbody align=\"center\">");
      writeln("<tr class=style2>");
      writeln("<th><a href=\"javascript:"+this.Name+".ChangeTable('client')\">client<\/a><\/th>");
      writeln("<th><a href=\"javascript:"+this.Name+".ChangeTable('first connect')\">first connect<\/a><\/th>");
      writeln("<th><a href=\"javascript:"+this.Name+".ChangeTable('last connect')\">last connect<\/a><\/th> ");
      writeln("<th><a href=\"javascript:"+this.Name+".ChangeTable('static relations')\">static relations<\/a><\/th> ");
      writeln("<th><a href=\"javascript:"+this.Name+".ChangeTable('SLP relations')\">SLP relations<\/a><\/th> ");
      writeln("<th><a href=\"javascript:"+this.Name+".ChangeTable('DLP relations')\">DLP relations<\/a><\/th> ");
      writeln("<th><a href=\"javascript:"+this.Name+".ChangeTable('rate')\">rate<\/a><\/th> ");
      writeln("<\/tr>");
      for (var i=0; i<this.NetClientsArray.length; ++i)
       {
         writeln("<tr class=style"+((i%2)+1)+" id=\""+this.Name+"NCTR"+i+"\" >");
         for (var j=0; j<this.NetClientsArray[i].length; ++j)
          {
            writeln("<td id=\""+this.Name+"NCTD"+i+"_"+j+"\" >"+this.NetClientsArray[i][j]+"<\/td>");
          }
         writeln("<\/tr>");
       }
      writeln("<\/table>");
    }
   var s = document.getElementById(this.Name+"NCCHANGEME");
   var n = document.getElementById(this.Name+"NCTABLE");
   s.parentNode.replaceChild(n,s);
 }

function TableOfNetClients_ChangeTable(sort_by)
 {
   SetCookieValue("collapse_depth",this.collapse_depth);
   this.sort(sort_by);
   if (sort_by!="")
    {
      var addstr="";
      if (this.collapse_depth>0) addstr=" ("+this.collapse_depth+"x collapsed)";
      MyReplace(this.Name+"NCH3","Status of connected net-clients sorted by "+sort_by+addstr);
    }
   for (var i=0; i<this.NetClientsArray.length; ++i)
     for (var j=0; j<this.NetClientsArray[i].length; ++j)
       MyReplace(this.Name+"NCTD"+i+"_"+j,this.NetClientsArray[i][j]);
 }

function TableOfNetClients_AccumulateSubnets(depth)
 {
   if (!depth) depth=1;
   for (var i=0; i<this.NetClientsArray.length; ++i)
    for (var j=0; j<depth; ++j)
     if (this.NetClientsArray[i][0].indexOf('.')>=0)
      {
        if (isNaN(this.NetClientsArray[i][0].substring(this.NetClientsArray[i][0].lastIndexOf('.')+1,this.NetClientsArray[i][0].length)))
         this.NetClientsArray[i][0]=this.NetClientsArray[i][0].substring(this.NetClientsArray[i][0].indexOf('.')+1,this.NetClientsArray[i][0].length); // cut symbolic IP left to right 
        else
         this.NetClientsArray[i][0]=this.NetClientsArray[i][0].substring(0,this.NetClientsArray[i][0].lastIndexOf('.')); // cut numeric IP right to left
      }

   for (var i=0; i<this.NetClientsArray.length; ++i)
    for (var j=i+1; j<this.NetClientsArray.length; ++j)
     while ((this.NetClientsArray[j]) && (this.NetClientsArray[i][0]==this.NetClientsArray[j][0]))
      {
        if (CompareFirstConnect(this.NetClientsArray[i],this.NetClientsArray[j])>0) this.NetClientsArray[i][1]=this.NetClientsArray[j][1];
        if (CompareLastConnect(this.NetClientsArray[i],this.NetClientsArray[j])>0) this.NetClientsArray[i][2]=this.NetClientsArray[j][2];
        for (var k=3; k<this.NetClientsArray[i].length; ++k) this.NetClientsArray[i][k]=parseFloat(this.NetClientsArray[i][k])+parseFloat(this.NetClientsArray[j][k]);
        this.NetClientsArray[i][6]=this.NetClientsArray[i][6].toFixed(2)+"%";
        for (var k=j+1; k<this.NetClientsArray.length; ++k) this.NetClientsArray[k-1]=this.NetClientsArray[k];
        this.NetClientsArray.pop();
        var s;
        if (s=document.getElementById(this.Name+"NCTR"+this.NetClientsArray.length))
         {
           // remove also the corresponding html table row
           this.removedChildren.push(s.parentNode.removeChild(s));
         }
      }
   //alert("Rounding errors may lead to minor inaccuracies!");
   this.collapse_depth+=depth;
   this.ChangeTable(this.sorted_by);
 }

function TableOfNetClients_AccumulateSubnets_undo(steps)
 {
   if (!steps) steps=1;
   if (this.collapse_depth<1) return;
   if (steps>this.collapse_depth) steps=this.collapse_depth;
   this.collapse_depth-=steps;

   // clear the current NetClientsArray
   for (var i=0; i<this.NetClientsArray.length; ++i) delete(this.NetClientsArray[i]);
   delete(this.NetClientsArray);

   // and replace it by a copy (not just a reference) of NetClientsArray_orig
   this.NetClientsArray = new Array();
   for (var i=0; i<this.NetClientsArray_orig.length; ++i)
     this.NetClientsArray.push(this.NetClientsArray_orig[i].slice(0,this.NetClientsArray_orig[i].length));

   // restore original html table
   var s = document.getElementById(this.Name+"NCTR"+1);
   if (s)
    for (var i=0; i<this.removedChildren.length; ++i)
     {
       s.parentNode.appendChild(this.removedChildren[i]);
     }
   delete(this.removedChildren); this.removedChildren = new Array();

   // and collapse again (to the desired depth)
   steps = this.collapse_depth;
   this.collapse_depth=0;
   if (steps>0) this.AccumulateSubnets(steps);
   else this.ChangeTable(this.sorted_by);
 }
