/*! @file
 * @brief
 * contains proxy class implementation for handling SIGUSR signals
 */

#include "usr_signals.H"

// this is tiny and somewhat "dirty"
// the stuff presented here is not interrupt-safe!
// so it could be that a signal just gets lost!
// (but in the moment we just don't care about...)


bool Cusr_signal_proxy::SIGUSR1_received = false;
bool Cusr_signal_proxy::SIGUSR2_received = false;

void Cusr_signal_proxy::signalhandler(int intr_signal)
{
  if (intr_signal==SIGUSR1)
   {
     SIGUSR1_received=true;
     signal(SIGUSR1,signalhandler);
   }
     
  if (intr_signal==SIGUSR2)
   {
     SIGUSR2_received=true;
     signal(SIGUSR2,signalhandler);
   }
}


#if 0
// just a small test
int main()
{
  Cusr_signal_proxy U;

  for (int i=0; i<100000; ++i)
   for (int j=0; j<1000000; ++j)
    {
      if (U.got_SIGUSR1()) return i/100;
    }
 return 0;
}
#endif
