/*! @file
 * @brief
 * A *very* simple example of a client server system
 *
 * written 2004-02 by Thorsten Reinecke
 *
 * compile with g++ -o notify notify.cc
 *
 * usage:
 *  - just use "notify" 
 *   to wait for a notification from somebody
 *
 *  - and use "notify <host> <message>"
 *   to send a notification to somebody
 */

#include <string>
#include <iostream>
#include "unix_buffer.H"

using namespace std;

const int server_port = 12365;

void send_notification(const string server, const string message)
{
  // client sends message to server
  cout << "sending notification to " << server << endl;
  unix_io_stream tcp(server,server_port);
  cout << tcp.connection_info() << endl;
  tcp << message << endl;
  string s;
  tcp >> s;
  cout << s << endl;
}

void wait_for_notification()
{
  // server waits for message from client
  connection_waiter my_connection_waiter(server_port);
  unix_io_stream tcp(my_connection_waiter); // wait for client call
  cout << tcp.connection_info() << endl;
  string s;
  tcp >> s;
  cout << "received: " << s << endl;
  tcp << "pong." << endl;
}

int main(const int argc, const char* const argv[])
{
 if (argc==1)
  {
    // server mode
    wait_for_notification();
    exit(0);
  }
 else if (argc==2 || argc==3)
  {
    // client mode
    send_notification(argv[1], (argc==3) ? argv[2] : "ping.");
    exit(0);
  }
 else
  {
    // invalid
    cout << "invalid parameters!" << endl;
    exit(1);
  }
}
