// very tiny ncurses window wrapper
// written 2004-02-13 by Thorsten Reinecke

/*! @file
 * @brief
 * very tiny ncurses window wrapper
 *
 */

#include <ncurses.h>
#include <cstdio>
#include <streambuf>
#include <ostream>

using namespace std;

/*!
 * @short
 * stream buffer class for accessing a ncurses window  
 *
 * This class wraps the ncurses functions to provide access to a window
 * through a stream buffer. The stream buffer is initialized with the
 * coordinates of the window.
 */
class outbuf : public streambuf
{
protected:
  WINDOW *win;
  
public:
 outbuf(int nlines, int ncols, int begin_y, int begin_x)
 {
   win=newwin(nlines,ncols,begin_y,begin_x);
 #if 1 /* window with outside border */
   box(win, 0 , 0);                /* 0, 0 gives default characters
                                    * for the vertical and horizontal
                                    * lines                        */
   wrefresh(win);
   delwin(win);
   if (nlines==0) nlines=LINES-begin_y;
   if (ncols==0) ncols=COLS-begin_x;
   win=newwin(nlines-2,ncols-2,begin_y+1,begin_x+1);
 #endif

   scrollok(win,true);
 }

 ~outbuf()
 {
   delwin(win); win=NULL;
 }

 int wgetch()
 {
   return ::wgetch(win);
 }

protected:
 virtual int overflow (int c)
 {
   waddch(win,c);
   wrefresh(win);
   return c;
 } 
};


/*!
 * @short
 * stream class for accessing a ncurses window  
 *
 * This class wraps the ncurses functions to provide access
 * to a window through a stream. The stream is initialized with
 * the coordinates of the window.
 */
class Cwin : public ostream
{
protected:
 outbuf mywindow;
public:
 Cwin(int nlines, int ncols, int begin_y, int begin_x)
  : ostream(&mywindow), mywindow(nlines,ncols,begin_y,begin_x)
  { }

 int wgetch() { return mywindow.wgetch(); }

};


static void exit_my_ncurses();
static bool init_called = false;

static void init_my_ncurses()
{
  if (init_called) exit(94); // error, error!!
  initscr();                      // Start curses mode
  cbreak();                       // Line buffering disabled, pass on everything to me
  static bool installed = false;
  if (!installed) atexit(exit_my_ncurses);
  installed=true;
  init_called=true;
}

static void exit_my_ncurses()
{
  if (init_called)
   {
     endwin();           /* End curses mode */
     init_called=false;
   }
}



#if 0
int main()
{
 initscr();                      // Start curses mode
 cbreak();                       // Line buffering disabled, pass on everything to me
 Cwin win1(5,40,10,12);
 Cwin win2(5,40,16,7);

 for (int i=0; i< 100; ++i)
  {
    win1 << "Hallo! " << i << endl;
    win2 << i;
    sleep(1);
  }

 sleep(10);
 
 endwin();                       /* End curses mode */
};
#endif
