/*! @file
 * @brief
 * variant part of the elliptic curve implementation,
 * must be compiled separately from the invariant part
 */

// this is the variant part of the elliptic curve implementation
// and it must be compiled separately from the invariant part

// this is because of:
// invariant part: qsieve, net-client and server do share the same code
// variant part: qsieve, net-client and server do not share the same code

#if defined(IS_SERVER) || !defined(USE_NETWORK)

void elliptic_curves::factor_found(mpz_t k) const
{
  cout << endl << "factor found in elliptic curve" << endl;
  if (mpz_cmp(k,n)==0) // factor = n ?
   {
     cout << "Factorization is trivial, aborting..." << endl;
     return; // trivial factor -> abort
   }

#ifdef IS_CLIENT
  ostream& Factorization_to_file = cout;
#endif

  if (mpz_probab_prime_p(k,probab_prime_checks))
    {
      const unsigned int exponent = mpz_remove(n,n,k);
      cout << k << " is factor." << endl;

      if (mpz_sizeinbase(k,10)<28)
       {
         ostringstream comment;
         comment << " [ecm" << phase << "]";
         Factorization_to_file << MAL(k,exponent,comment) << flush;
       }
      else
       {
         ostringstream comment;
         comment << " [ecm" << phase << ",sigma=" << sigma << "]";
         Factorization_to_file << MAL(k,exponent,comment) << flush;
       }
    }
  else
    {
      mpz_t h;
      mpz_init(h); const unsigned int exponent = mpz_remove(h,n,k);
      cout << k << " is a composite factor." << endl;
      if (mpz_probab_prime_p(n,probab_prime_checks))
       {
	 mpz_swap(n,k);
	 cout << k << " is factor. (factorswap)" << endl;
         ostringstream comment;
         comment << " [ecm" << phase << "/factorswap,sigma=" << sigma << "]";
         Factorization_to_file << MAL(k,comment) << flush;
       }
      else
       {
	 mpz_set(n,h);
         if (mpz_sizeinbase(k,10)<28)
          {
            ostringstream comment;
            comment << " [ecm" << phase << "] [composite]";
            Factorization_to_file << MAL(k,exponent,comment) << flush;
          }
         else
          {
            ostringstream comment;
            comment << " [ecm" << phase << ",sigma=" << sigma << "] [composite]";
            Factorization_to_file << MAL(k,exponent,comment) << flush;
          }
       }
      mpz_clear(h);
    }
}

#else
// net-client-mode -> transmit factor to server

void elliptic_curves::factor_found(mpz_t k) const
{
  cout << endl << "factor found in elliptic curve, phase " << phase << endl;
  if (mpz_cmp(k,n)==0) // factor = n ?
   {
     cout << "Factorization is trivial, aborting..." << endl;
     return; // trivial factor -> abort
   }
  if (mpz_probab_prime_p(k,probab_prime_checks))
    {
      cout << k << " is factor." << endl;
    }
  else
    {
      cout << k << " is composite factor." << endl;
    }
  mpz_remove(n,n,k);

  unix_io_stream communication_stream(communication_name, server_port);
  communication_stream << "Faktor(ECM)! ";
  communication_stream << sigma << " " << k << " " << "ecm" << phase << endl;

  cout << "factor sent to server." << endl;
}

#endif
