#ifndef EASY_FACTOR_HEADER_
#define EASY_FACTOR_HEADER_

/*! @file
 * @brief
 * contains declaration of the simpler factoring algorithms
 */

#include <gmp.h>
#include <string>
#include "utils.H"
#include "mpz_wrapper.H"
using namespace my_mpz_wrapper;

using std::ostream;
using std::istream;

using std::cout;
using std::cerr;

// parameters for easy-factorization (defaults)
extern bool SkipFermat;
extern bool SkipPhi;
extern bool SkipFibonacci;
extern bool SkipEasyECM;
extern bool SkipECM;
extern int rho_Phase;
extern int phi_Phase1;
extern double phi_Phase2;
extern double elcu_Phase1;
extern double elcu_Phase2;
extern int elcu_Kurven;


/// Pollard-rho method
void pollard(const int runden);

/// trial division by some factors given in a file...
bool try_memorized_factors(mpz_t n, const std::string& memfilename);

/// check for perfect powers
bool Potenztest(const mpz_t n);

/// factoring method similar to fermat
void fermat_like_method();

/// factoring method something between fermat and phi
void phimat(mpz_t n);

/// trial division and a combination of other methods
void easy_factor();

#endif /* EASY_FACTOR_HEADER_ */
