/*! @file
 * @brief
 * implementation of a server providing XML status reports via TCP
 */


/// XML status report server class 
class CXML_StatusServer
{
 public:
  static void install_XML_StatusServer();
  static void* THREAD_XML_StatusServer(void*);
};


void* CXML_StatusServer::THREAD_XML_StatusServer(void*)
{
  ExitManager::register_cancel();
  //cout << "Hello, I'm the XML Status Server, thread id = " << pthread_self() << endl;
  const connection_waiter my_connection_waiter(XML_status_port);
  while (true)
   {
     unix_io_stream tcp(my_connection_waiter.get_new_client_socket_descriptor()); // wait for client call
     statistical_data::XML_StatusReport(tcp);
   }
}


void CXML_StatusServer::install_XML_StatusServer()
{
  static pthread_attr_t detached_thread;
  static pthread_t thread_process_XML;

  pthread_attr_init(&detached_thread);
  pthread_attr_setdetachstate(&detached_thread, PTHREAD_CREATE_DETACHED);
  
  cout << "installing XML status server..." << endl;

  const int retcode = pthread_create(&thread_process_XML,
    &detached_thread,CXML_StatusServer::THREAD_XML_StatusServer, NULL);

  if (retcode != 0)
   {
     cerr << "pthread_create failed!" << endl;
     exit(1);
   }

  cout << "XML status server installed." << endl;
}
