/*! @file
 * @brief
 * declaration of class StaticRelations
 */


#ifndef STATIC_RELATIONS_HEADER_
#define STATIC_RELATIONS_HEADER_


class StaticRelations : private StaticFactorbaseSettings
{
 // this class is just here to encapsulate access to the functions
 // which are specific for handling static relations

 private:
  static CRelation* GLS[StaticFactorbase::MaxSize];
   // linear system of equations consisting of pointers to relations;
   // initialized with Null-pointers, (since there are no relations at the
   // beginning)

  static int Filling_GLS; // #relations in system of equations

  // To store the relations of the static factorbase to external memory,
  // we provide the following streams:
  static filebuf FileBuffer;
  static ostream StaticRelations_to_file;
  static istream StaticRelations_from_file;

 public:
  static void insert(CRelation *GL, const bool do_multi_combine_init=true);
  static void Load();

  static const int Count() { return Filling_GLS; }
  static void cleanup_files()
   {
     FileBuffer.close();
     remove(StaticRelationsFile.c_str());
   }
  static void cleanup_memory()
   {
     int count = 0;
     for (int i=0; i<StaticFactorbaseSettings::MaxSize; ++i)
      if (GLS[i]) { delete GLS[i]; ++count; }
     Filling_GLS=0;
#ifdef VERBOSE_INFO
     cout << count << " relations deallocated." << endl;
#endif
   }
 friend int main(const int argc, const char* const argv[]);
};

#endif /* STATIC_RELATIONS_HEADER_ */
