/*! @file
 * @brief
 * contains declaration for static factorbase
 */

#ifndef STFB_HEADER_
#define STFB_HEADER_

#include "qsieve-fwd.H"

#include "mpz_wrapper.H"
using namespace my_mpz_wrapper;

#include "modulo.H"


class StaticFactorbase : public StaticFactorbaseSettings
{
 public:
  static int NumberOf_more_PrimePowers; // actual number (will be evaluated at runtime)
  static int FB_maxQuadrate; // actual number of squares to sieve with (will be evaluated at runtime)

 protected:
  static int PrimePowers[StaticFactorbase::max_additional_Powers];
  static int PrimePowerReciprocals[StaticFactorbase::max_additional_Powers];
  static int SQRT_kN_of_PrimeNumbers[MaxSize];
  static int SQRT_kN_of_PrimePowers[StaticFactorbase::max_additional_Powers];
  static int SQRT_kN_of_PrimeSquares[StaticFactorbase::MaxSize];

 public:
  static void compute_StaticFactorbase();
};


extern mpz_t kN; // input for MPQS (includes a suitable multiplier)
extern int MPQS_Multiplier; // multiplier for n (kN=MPQS_Multiplier*n), will be determined later!
extern int LogicalSieveSize; // sieving interval will be [-LogicalSieveSize,LogicalSieveSize] for each MPQS polynomial


inline int SQRT_kN_mod_PrimeNumber(const unsigned int Primzahl)
{
  return numtheory::sqrtmod(mpz_remainder_ui(kN,Primzahl),Primzahl);
}

int check_SQRT_kN_mod_PrimeNumber(const int Primzahl);

void determine_best_MPQS_Multiplier(const mpz_t n, mpz_t kN, int &new_MPQS_Multiplier);

#endif /* STFB_HEADER_ */
