/*! @file
 * @brief
 * declaration of class SpecialRelations; handling double large prime stuff
 */


#ifndef SPECIAL_RELATIONS_HEADER_
#define SPECIAL_RELATIONS_HEADER_


struct myintcompare
{
  inline const bool operator() (const int i1, const int i2) const
   {
     return i1 < i2;
   }
};
typedef set<int, myintcompare> intset;



/*!
 * @short
 * This class handles a double large prime factor for accessing
 * it on file.
 * (special factor = factor containing two (single) large primes)
 */
struct TSpecialFactorRelation {
  CmpqsFactor factor;
  streampos fpos;

  inline bool operator() (const TSpecialFactorRelation &t1, const TSpecialFactorRelation &t2) const
    { 
      return t1.factor<t2.factor;
    }
};


class SpecialRelations : private DynamicRelations
{
 // this class is just here to encapsulate access to the functions
 // which are specific for handling special relations
 // (and special factors (=DLP, double large prime factors outside the static factorbase)

 private:
  typedef set<TSpecialFactorRelation,TSpecialFactorRelation> TSpecialFactorRelations;
  static TSpecialFactorRelations SpecialFactorRelations;

  // Fr die Relationen zu den Specialfactors
  // streams fr das Datenfile zur Verfgung stellen:
  static filebuf FileBuffer;
  static ostream SpecialRelations_to_file;
  static istream SpecialRelations_from_file;

 public:
  static const int Count() { return SpecialFactorRelations.size()/2; }
  static void cleanup_files()
   {
     FileBuffer.close();
     remove(SpecialRelationsFile.c_str());
   }
  static void CycleSearch();
  static bool insert(const CmpqsFactor &DLP, CRelation *GL, const short int HitCount=0);
  static bool insert(const CmpqsFactor &DLP, const string &GL_String);
  static bool SpecialFactor_splitable(const CmpqsFactor &DLP);
  static void split_by_primefactor(const int Primfaktor);
  static void Load();
  friend int main(const int argc, const char* const argv[]);
};

#endif /* SPECIAL_RELATIONS_HEADER_ */
