#ifndef Client_IO_H
#define Client_IO_H

/*! @file
 * @brief
 * declaration of concepts for client-sided I/O to the server
 */


/// concept for fetching mpqs polynomial intervals from server
class CClientPolynomFetcher
{
private:
  static string buffer;
  static void * THREAD_fetch_polynom(void *);
public:
  static void fetch(mpz_t UpperBound_D);
};


#include <queue>

/// concept for fetching dynamic factors from server
class CClientDynamicFactorFetcher
{
  static CMutex Mutex;
  static std::queue<int> buffer;
private:
  static void * THREAD_fetch_DynamicFactors(void *);
public:
  static void fetch();
};


/// concept for delivery of sieved relations to the server
class CClientRelation_Delivery
{
private:
  static istream& PipeInput;
  static void init(void);
  static void * THREAD_transmit_Relations(void * arg);
 friend int main(const int argc, const char* const argv[]);
};

#endif /* Client_IO_H */
