/*! @file
 * @brief
 * Another *very* simple example of a client server system
 *
 * written 2004-11 by Thorsten Reinecke
 *
 * compile with g++ -o talk talk.cc -I../src/ -lncurses -pthread
 *
 * usage:
 *  - just use "talk"
 *   to wait for an incoming talk request from anybody
 *
 *  - and use "talk <host>"
 *   to request a talk
 *
 * After the connection has been established you can talk.
 */

#include <string>
#include <iostream>
#include "unix_buffer.H"
#include "my_ncurses.H"

using namespace std;

const int server_port = 19999; // or whatever port you wish
 // only constraint: client & server must use the same port


int main(const int argc, const char* const argv[])
{

 unix_io_stream *tcp;

 if (argc==1)
  {
    // server mode
    cout << "Talk, server mode, waiting for client at port "
         << server_port << endl;
    // server waits for client
    connection_waiter my_connection_waiter(server_port);
    tcp=new unix_io_stream(my_connection_waiter); // wait for client call
  }
 else if (argc==2)
  {
    // client mode
    cout << "Talk, client mode, sending request to "
         << argv[1] << " " << server_port << endl;
    tcp = new unix_io_stream(argv[1],server_port);
  }
 else
  {
    // invalid
    cout << "invalid parameters!" << endl;
    exit(1);
  }


  init_my_ncurses();
  noecho();
  halfdelay(1); /* ncurses function for input:
                   getch() can be used for reading chars,
                   if no input is available within n/10 seconds,
                   then -1 is returned. */


  Cwin win1(12,0,0,0);
  Cwin win2(0,0,12,0);

  win2 << tcp->connection_info() << endl;

  Cpoll you(*tcp);

  while (*tcp && you.good())
   {
     int i;
     while ((i=you.readable_chars_within(100,50))>0)
      {
        char s[i+1];
        tcp->read(s,i);
        win2.write(s,i);
        win2.flush();
      }

     while ( (i=win1.wgetch()) >0)
      {
        char ch = i; 
        win1 << ch << flush;
        tcp->put(ch); tcp->flush();
      }
   }

  delete tcp;
}
