#!/bin/bash
# small script written 2004-04-24 by Thorsten Reinecke
# parameter $1 : program to profile

# using oprof,
# refer http://oprofile.sourceforge.net

# to do before start profiling using oprof:
# become root: 
#  opcontrol --no-vmlinux
#  opcontrol --start
#  opcontrol --reset
# and after profiling:
# become root:
#  opcontrol --shutdown
#  opcontrol --deinit


# show all functions that consume at least 0.5% of computing time
opreport -l -g -t 0.5 $1

ANNOTATE="qsieve.cc,modulo.cc"

# annotate the hot spots listed in $ANNOTATE (which consume at least 7.5% of computing time)
opannotate -t 7.5 --source --assembly --include-file $ANNOTATE $1
