#!/bin/bash

if [ "$1" != "watchmode" ] ; then
 #cd /tmp/qsieve-2.98-rc1
 $0 watchmode &
 while true; do
   qsserver=`dig +short qsieve.net`
   nice -n 19 ./net-client $qsserver
   sleep 100
 done
 exit 0
fi

idlecounter=0
while true; do
  if !( ps auxwwww | grep -v grep | grep $0 | grep -v watchmode >/dev/null ); then
    # suicide watchdog if there is no netsieve script to watch
    exit 0;
  fi
  status=`ps auxwwww | grep net-client | grep -v grep | awk '{ print $8 }'`
  #echo -n "status=$status idle=$idlecounter "
  #date
  if [ "$status" == "SN" ] ; then let idlecounter++
  else idlecounter=0; fi
  if [[ $idlecounter -gt 3 ]] ; then
    #echo "restarting net-client"
    ( echo -n "$HOSTNAME restarted at "; date ) >>~/restart.log
    psid=`ps auxwwww | grep net-client | grep -v grep | awk '{ print $2 }'`
    kill $psid
    idlecounter=0
  fi
  sleep 60
done
