#ifndef utils_dot_H_header
#define utils_dot_H_header

/*! @file
 * @brief
 * contains some small utilities (macros, templates and more)
 */


// helper for debugging sessions ;-)
#define MARK  cout << "now in " << __FILE__ << ", " << __FUNCTION__ << ": line " <<  __LINE__ << endl;


// define templates for MIN and MAX:
template<typename T> inline T MIN(const T a, const T b) { return (a<=b) ? a : b; }
template<typename T> inline T MAX(const T a, const T b) { return (a>=b) ? a : b; }


/*!
 * This class forbids the uses of implicit inherited assigment operators
   by declaring/defining private assignment class functions.
 */
class ForbidAssignment
{
 public:
  inline ForbidAssignment() { }
 private:
  ForbidAssignment(const ForbidAssignment&); // declaration intentianally without implementation!
  inline const ForbidAssignment& operator= (const ForbidAssignment&) const { return *this; }
  // only a dummy declaration/definition to forbid any implicit inherited use
  // of the assignment operator
};


#if (__GNUC__ == 3) && (__GNUC_MINOR__ < 4)
// gcc 3.3.x and probably versions below seem to need a mechanism to avoid
// ambiguity between "long double sqrt(long double)" and "double
// sqrt(double)" when argument is an integer type. We could define them
// directly for the integer types involved (but if we use "long long" in
// advance, we would get compile errors on compilers that do not support
// these types.)
// so, hmmm, yeah: let's define the affected functions as templates

template<typename T> inline double sqrt(const T x)
{
  return std::sqrt(static_cast<double>(x));
} 
template<typename T> inline double log(const T x)
{
  return std::log(static_cast<double>(x));
}
#endif


#endif
