#include <csignal>

// this is tiny and somewhat "dirty"
// the stuff presented here is not interrupt-safe!
// so it could be that a signal just gets lost!
// (but in the moment we just don't care about...)

/*! @file
 * @brief
 * contains proxy class for handling SIGUSR signals
 */


class Cusr_signal_proxy
{
private:
 static bool SIGUSR1_received;
 static bool SIGUSR2_received;
 static void signalhandler(int signal);
 sighandler_t dflusr1, dflusr2;
 bool previous1,previous2;
public:
 Cusr_signal_proxy()
  {
    previous1=SIGUSR1_received; SIGUSR1_received=false;
    dflusr1=signal(SIGUSR1,signalhandler);
    previous2=SIGUSR2_received; SIGUSR2_received=false;
    dflusr2=signal(SIGUSR2,signalhandler);
  }
 ~Cusr_signal_proxy()
  {
    SIGUSR1_received=previous1;
    dflusr1=signal(SIGUSR1,dflusr1);
    SIGUSR2_received=previous2;
    dflusr1=signal(SIGUSR2,dflusr2);
  }
 const bool got_SIGUSR1()
  {
    if (SIGUSR1_received) { SIGUSR1_received=false; return true; }
    return false;
  }
 const bool got_SIGUSR2()
  {
    if (SIGUSR2_received) { SIGUSR2_received=false; return true; }
    return false;
  }
};

bool Cusr_signal_proxy::SIGUSR1_received = false;
bool Cusr_signal_proxy::SIGUSR2_received = false;

void Cusr_signal_proxy::signalhandler(int intr_signal)
{
  if (intr_signal==SIGUSR1)
   {
     SIGUSR1_received=true;
     signal(SIGUSR1,signalhandler);
   }
     
  if (intr_signal==SIGUSR2)
   {
     SIGUSR2_received=true;
     signal(SIGUSR2,signalhandler);
   }
}


#if 0
// just a small test
int main()
{
  Cusr_signal_proxy U;

  for (int i=0; i<100000; ++i)
   for (int j=0; j<1000000; ++j)
    {
      if (U.got_SIGUSR1()) return i/100;
    }
 return 0;
}
#endif
