// Die folgenden Routinen dienen dazu, Quadratwurzeln modulo Primzahlen
// zu ermitteln.
// Zu beachten:
// Radikant und Primzahl im unsigned int Bereich (besser: unsigned int/2)
// Radikant mu normiert sein, d.h. 0 <= Radikant < Primzahl
// Die Primzahleigenschaft wird aus Effizienzgrnden nicht geprft!
// (ggf. vor Aufruf mit is_prime/is_probab_prime testen)
// Es ebenfalls wird nicht geprft, ob eine Wurzel berhaupt existiert!
// (ggf. vor Aufruf mit legendre(Radikant,Primzahl)=1 Existenz prfen) 

// written by Thorsten Reinecke 1998,1999
// last change: 2003-12-29

// now it should be threadsafe


/*! @file
 * @brief
 * compute square roots modulo prime numbers (unsigned int)
 */


namespace numtheory
{

class Clucas_capsule
{
 private:
  static const int lucas_cache_size = 128;
  unsigned int lucas_p, lucas_q, lucas_p_inv;
  int lucas_cache_index;
  unsigned int lucas_cache [lucas_cache_size][2];
  unsigned int lucasv(const unsigned int Primzahl, const unsigned int m);
 public:
  inline Clucas_capsule(void) : lucas_cache_index(0) { }
  unsigned int lucas(const unsigned int Radikant, const unsigned int Primzahl);  
};


unsigned int Clucas_capsule::lucasv(const unsigned int Primzahl, const unsigned int m)
{
  if (m==0) return 2;
  if (m==1) return lucas_p;
  
  /* Wert schonmal vorher berechnet? */
  for (int i=lucas_cache_index-1; i>=0; --i)
    {
      if (lucas_cache[i][0]==m) return lucas_cache[i][1];
    }
  
  unsigned int wert; /* Rckgabewert fr lucas_v */
  // printf("lucasv(%i)\n",m);
  
  if (m&1)
    {
      const unsigned int h1=lucasv(Primzahl,m+1);
      const unsigned int h2=lucasv(Primzahl,m-1);
      register unsigned int xx;
      xx=mulmod(h2,lucas_q,Primzahl)+h1;
      wert=mulmod(xx%Primzahl,lucas_p_inv,Primzahl);
    }
  else
    {
      const unsigned int h1=lucasv(Primzahl,m>>1);
      unsigned int xx;
      xx=(powmod(lucas_q,m>>1,Primzahl)<<1)%Primzahl;
      wert=(squaremod(h1,Primzahl)+Primzahl-xx)%Primzahl;
  
      // Wert in den Cache schreiben...
      if (lucas_cache_index<lucas_cache_size)
        {
          lucas_cache[lucas_cache_index][0]=m;
          lucas_cache[lucas_cache_index++][1]=wert;
        } else cerr << "Lucas-Cache sollte vergrert werden!" << endl;
    }
  return wert;
}


unsigned int Clucas_capsule::lucas(const unsigned int Radikant, const unsigned int Primzahl)
{
  if ((Primzahl&3)!=1)
    { cerr << "Fehler in Lucassequenz Primzahl%4<>1!: " << Primzahl%4 << endl; exit(1); }
  
  /* lucas_p ermitteln */
  lucas_q=Radikant;
  lucas_p=1;
 
  {
    int h1,h2;
    do
     {
       lucas_p++;
       h1=squaremod(lucas_p,Primzahl);
       h2=mulmod(4,lucas_q,Primzahl);
       if (h1>=h2) h1-=h2; else h1=Primzahl-(h2-h1);
     } while (legendre(h1,Primzahl)!=-1);
  }

  /* nun das Inverse von lucas_p bezglich Primzahl ermitteln */ 
  lucas_p_inv=invmod(lucas_p,Primzahl);
  
  //cout << "Lucas-Cache was " << lucas_cache_index << endl;
  lucas_cache_index=0; /* Cache lschen!! */
  
  /* jetzt die Wurzel von n errechnen */
  unsigned int v=lucasv(Primzahl,(Primzahl+1)>>1);
  /* im folgenden v noch durch 2 teilen (aber modulo Primzahl!!) */
  if (v&1) v+=Primzahl;
  return v>>1;
}


/*!
 * @param Radikant an unsigned integer value
 * @param Primzahl an prime unsigned integer value
 * @result square root of @p Radikant mod @p Primzahl,
 *         that is an unsigned integer value @p r,
 *         such that @p r * @p r mod @p Primzahl = @p Radikant
 * @remark
 *   - primility of @p Primzahl isn't checked
 *     - the result is undefined, if @p Primzahl is composite 
 *     - you can check this beforehand using is_prime() or probab_prime()
 *   - if no solution exists, the result is undefined
 *     - you can use legendre() to check, whether a solution exists
 */
unsigned int sqrtmod(const unsigned int Radikant, const unsigned int Primzahl)
{
  /* hier knnte zunchst noch ein Primzahltest erfolgen, doch ich verlasse mich
     aus Effizienzgrnden darauf, da dieser Routine nur Primzahlen bergeben werden! */
  
  if ((Primzahl&3)==3)
    {
      /* Lsung kann auf einfache Weise effizient berechnet werden... */
      //cout << "sqrtmod: p=3 (mod 4)" << endl;
      return powmod(Radikant,(Primzahl+1)>>2,Primzahl);
    }
  else
    if ((Primzahl&7)==5)
      {
        /* Lsung kann ebenfalls auf einfache Weise effizient berechnet werden... */
        //cout << "sqrtmod: p=5 (mod 8)" << endl;
        unsigned int y = powmod(Radikant,(Primzahl+3)>>3,Primzahl);
        if (squaremod(y,Primzahl)==Radikant) return y;
        else 
          {
            unsigned int w=powmod(2,Primzahl>>2,Primzahl);
            return mulmod(y,w,Primzahl);
          }
      }
    else
     { 
       if (Radikant<=1) return Radikant; // Spezialfall: 0^2=0, 1^2=1
       /* schnelle Lsung mit Lucas-Sequenzen fr Primzahl=1 (mod 4) */
       //cout << "sqrtmod: p=1 (mod 4) -> Lucassequenzen" << endl;
       Clucas_capsule lucas_capsule;
       return lucas_capsule.lucas(Radikant,Primzahl);
     }
}

} // namespace numtheory
