#ifndef mutex_header
#define mutex_header

/*! @file
 * @brief
 * contains wrapper class for mutex (mutual exclusion) handling
 * in a C++ multithreaded environment
 */


extern "C"
{
 #include <pthread.h>
}

#include "utils.H"

class CMutex : private ForbidAssignment
{
 private: 
  pthread_mutex_t mutex;
 public:
  inline CMutex()
   {
     pthread_mutex_init(&mutex,NULL);
   }
  inline ~CMutex()
   {
#ifndef DEBUG
     pthread_mutex_destroy(&mutex);
#else /* nur beim Debugging wichtig */
     const int result = pthread_mutex_destroy(&mutex);
     if (result==EBUSY)
      {
        cerr << "cannot destroy busy mutex!!" << endl;
        exit(1);
      }
#endif
   }
  inline void lock()
   {
     const int result = pthread_mutex_lock(&mutex);
     switch (result)
      {
        case EINVAL:
          cerr << "the mutex has not been properly initialized." << endl;
          exit(1);
	case EDEADLK:
	  cerr << "the mutex is already locked by the calling thread" << endl;
	  exit(1);
      }
   }
  inline const bool trylock()
   {
     const int result = pthread_mutex_trylock(&mutex);
     switch (result)
      {
        case EINVAL:
          cerr << "the mutex has not been properly initialized." << endl;
          exit(1);
	case EBUSY:
	  cerr << "the mutex could not be acquired because it was currently locked." << endl;
	  return false;
      }
     return true;
   }
  inline void unlock()
   {
     const int result = pthread_mutex_unlock(&mutex);
     switch (result)
      {
        case EINVAL:
          cerr << "the mutex has not been properly initialized." << endl;
          exit(1);
        case EPERM:
          cerr << "the calling thread does not own the mutex" << endl;
          exit(1);
        case EBUSY:
          cerr << "the mutex is currently locked." << endl;
          exit(1);
      }
   }
};

#endif
