// Die folgenden Routinen dienen dazu, Quadratwurzeln modulo Primzahlen
// zu ermitteln.
// Zu beachten:
// Die Primzahleigenschaft wird aus Effizienzgrnden nicht geprft!
// (ggf. vor Aufruf mit is_probab_prime testen)
// Es ebenfalls wird nicht geprft, ob eine Wurzel berhaupt existiert!
// (ggf. vor Aufruf mit legendre(Radikant,Primzahl)=1 Existenz prfen) 

// written by Thorsten Reinecke 1998,1999
// last change: 2003-11-14

/*! @file
 * @brief
 * compute square roots modulo prime numbers (mpz numbers)
 */


// Bemerkung: Lucasfunktionen knnen auch ohne dynamische Programmierung
// in einer direkten Auswertung der Binrstellen berechnet werden.
// Dann wird nur konstanter Zusatzspeicher bentigt und der Cache kann entfallen.
// -> evtl. implementieren

class Clucas_capsule_mpz
{
 private:
  static const int lucas_cache_mpz_size = 500;
   // maximale Gre des Caches
   
  mpz_t lucas_cache_mpz [lucas_cache_mpz_size][2];
  
  int lucas_cache_mpz_index;
   // hier steht die Position des nchsten im Cache abzulegenden Wertes

  int lucas_cache_mpz_init_index;
   // erforderlich fr dynamische Speicherallokation

  mpz_t lucas_p_mpz, lucas_q_mpz, lucas_p_inv_mpz;

  void lucasv(mpz_t res, const mpz_t Primzahl, mpz_t m);
  
 public:
  Clucas_capsule_mpz() : lucas_cache_mpz_index(0), lucas_cache_mpz_init_index(0)
  {
    mpz_init(lucas_p_mpz); mpz_init(lucas_q_mpz); mpz_init(lucas_p_inv_mpz);
  }
  ~Clucas_capsule_mpz()
  {
    mpz_clear(lucas_p_mpz); mpz_clear(lucas_q_mpz); mpz_clear(lucas_p_inv_mpz);
    for (int i=0; i<lucas_cache_mpz_init_index; ++i)
     {
       //cerr << i << ": " << lucas_cache_mpz[i][0] << ": " << lucas_cache_mpz[i][1] << endl;
       mpz_clear(lucas_cache_mpz[i][0]);
       mpz_clear(lucas_cache_mpz[i][1]);
     }
  }
  void lucas(mpz_t v, const mpz_t Radikant, const mpz_t Primzahl);
};
 

void Clucas_capsule_mpz::lucasv(mpz_t res, const mpz_t Primzahl, mpz_t m)
{
  if (mpz_cmp_ui(m,0)==0) { mpz_set_ui(res,2); return; }
  if (mpz_cmp_ui(m,1)==0) { mpz_set(res,lucas_p_mpz); return; }
  
  /* Wert schonmal vorher berechnet? */
  for (int i=lucas_cache_mpz_index-1; i>=0; --i)
    {
      if (mpz_cmp(lucas_cache_mpz[i][0],m)==0)
       { 
         //cout << "Cache Hit!" << i << "/" << lucas_cache_mpz_index << ": " << m << endl;
         mpz_set(res,lucas_cache_mpz[i][1]);
         --lucas_cache_mpz_index; // der trifft nicht mehr
         mpz_swap(lucas_cache_mpz[i][0],lucas_cache_mpz[lucas_cache_mpz_index][0]);
         mpz_swap(lucas_cache_mpz[i][1],lucas_cache_mpz[lucas_cache_mpz_index][1]);
         return;
       }
    }
  
  if (mpz_odd_p(m)) // m ungerade
    {
      mpz_t h1;
      mpz_init(h1); mpz_sub_ui(m,m,1); lucasv(h1,Primzahl,m);
      mpz_mul(res,h1,lucas_q_mpz);
      mpz_add_ui(m,m,2); lucasv(h1,Primzahl,m); mpz_sub_ui(m,m,1);
      mpz_add(res,res,h1); mpz_mod(res,res,Primzahl);
      mpz_mul(res,res,lucas_p_inv_mpz); mpz_mod(res,res,Primzahl);
      mpz_clear(h1);
    }
  else // m gerade
    {
      mpz_t h1;
      mpz_init(h1); mpz_div_ui(m,m,2);
      lucasv(h1,Primzahl,m);

      mpz_powm(res,lucas_q_mpz,m,Primzahl); mpz_mul_ui(res,res,2);
      mpz_mod(res,res,Primzahl);
      mpz_mul_ui(m,m,2);
      
      mpz_mul(h1,h1,h1); mpz_mod(h1,h1,Primzahl);
      mpz_add(h1,h1,Primzahl); mpz_sub(res,h1,res);
      mpz_mod(res,res,Primzahl);
      mpz_clear(h1);
  
      // Wert in den Cache schreiben...
      // nur fr gerade Indices m erforderlich, da ja auch nur fr solche
      // ein rekursiver Aufruf erfolgt...
      if (lucas_cache_mpz_index<lucas_cache_mpz_size)
        {
          if (lucas_cache_mpz_init_index==lucas_cache_mpz_index)
           {
             mpz_init(lucas_cache_mpz[lucas_cache_mpz_init_index][0]);
             mpz_init(lucas_cache_mpz[lucas_cache_mpz_init_index++][1]);
           }
          mpz_set(lucas_cache_mpz[lucas_cache_mpz_index][0],m);
          mpz_set(lucas_cache_mpz[lucas_cache_mpz_index++][1],res);
        } else cerr << "Lucas-Cache sollte vergrert werden!" << endl;
    }
}


void Clucas_capsule_mpz::lucas(mpz_t v, const mpz_t Radikant, const mpz_t Primzahl)
{
  if (mpz_mod_ui(v,Primzahl,4)!=1)
    { cerr << "Fehler in Lucassequenz Primzahl%4<>1!: " << Primzahl << endl; exit(1); }
  
  /* lucas_p_mpz ermitteln */
  mpz_set(lucas_q_mpz,Radikant);
  mpz_set_ui(lucas_p_mpz,1);
 
  {
    mpz_t h1,h2;
    mpz_init(h1); mpz_init(h2);
    do
     {
       mpz_add_ui(lucas_p_mpz,lucas_p_mpz,1);
       mpz_powm_ui(h1,lucas_p_mpz,2,Primzahl); //h1=squaremod(lucas_p,Primzahl);
       mpz_mul_ui(h2,lucas_q_mpz,4); mpz_mod(h2,h2,Primzahl); //h2=mulmod(4,lucas_q_mpz,Primzahl);
       
       //if (h1>=h2) h1-=h2; else h1=Primzahl-(h2-h1);
       if (mpz_cmp(h1,h2)>=0) mpz_sub(h1,h1,h2);
       else { mpz_sub(h1,h2,h1); mpz_sub(h1,Primzahl,h1); }
     } while (mpz_legendre(h1,Primzahl)!=-1);
    mpz_clear(h1); mpz_clear(h2);
  }

  /* nun das Inverse von lucas_p_mpz bezglich Primzahl ermitteln */ 
  mpz_invert(lucas_p_inv_mpz,lucas_p_mpz,Primzahl); mpz_mod(lucas_p_inv_mpz,lucas_p_inv_mpz,Primzahl);
  
  //cout << "Lucas-Cache was " << lucas_cache_mpz_index << endl;
  lucas_cache_mpz_index=0; /* Cache lschen!! */
  
  /* jetzt die Wurzel errechnen */
  mpz_t m;
  mpz_init(m); mpz_add_ui(m,Primzahl,1); mpz_div_ui(m,m,2);
  lucasv(v,Primzahl,m);
  mpz_clear(m);

  /* im folgenden v noch durch 2 teilen (aber modulo Primzahl!!) */
  if (mpz_odd_p(v)) mpz_add(v,v,Primzahl);
  mpz_div_ui(v,v,2);
}


void mpz_sqrtmod(mpz_t res, const mpz_t Radikant_bel, const mpz_t Primzahl)
{
  /* hier knnte zunchst noch ein Primzahltest erfolgen, doch ich verlasse mich
     aus Effizienzgrnden darauf, da dieser Routine nur Primzahlen bergeben werden! */

  // Radikant kann beliebige Gre haben oder negativ sein, deshalb normieren:
  mpz_t Radikant;
  mpz_init(Radikant); mpz_mod(Radikant,Radikant_bel,Primzahl);
  
  if (mpz_mod_ui(res,Primzahl,4)==3)
    {
      /* Lsung kann auf einfache Weise effizient berechnet werden... */
      //cout << "sqrtmod: p=3 (mod 4)" << endl;
      mpz_t h; mpz_init(h); mpz_add_ui(h,Primzahl,1); mpz_div_ui(h,h,4);
      mpz_powm(res,Radikant,h,Primzahl);
      mpz_clear(h);
      //return powmod(Radikant,(Primzahl+1)>>2,Primzahl);
    }
  else
    if (mpz_mod_ui(res,Primzahl,8)==5)
      {
        /* Lsung kann ebenfalls auf einfache Weise effizient berechnet werden... */
        //cout << "sqrtmod: p=5 (mod 8)" << endl;
        mpz_t y;
        mpz_init(y); mpz_add_ui(y,Primzahl,3); mpz_div_ui(y,y,8);
        mpz_powm(y,Radikant,y,Primzahl);
        mpz_powm_ui(res,y,2,Primzahl);
        if (mpz_cmp(res,Radikant)==0) mpz_set(res,y);
        else
          {
            mpz_t Pviertel;
            mpz_init(Pviertel); mpz_div_ui(Pviertel,Primzahl,4);
            mpz_set_ui(res,2); mpz_powm(res,res,Pviertel,Primzahl);
            mpz_mul(res,res,y); mpz_mod(res,res,Primzahl);
            mpz_clear(Pviertel);
          }
        mpz_clear(y);
      }
    else
     { 
       mpz_mod(res,Radikant,Primzahl);
       if (mpz_cmp_ui(res,1)>0) // Spezialflle: 0^2=0, 1^2=1 weglassen
        {
          /* schnelle Lsung mit Lucas-Sequenzen fr Primzahl=1 (mod 4) */
          //cout << "sqrtmod: p=1 (mod 4) -> Lucassequenzen" << endl;
          Clucas_capsule_mpz capsulated;
           // if thread-safety is no issue, then you can speed-up things a bit
           // in making capsulated a static variable...
          capsulated.lucas(res,Radikant,Primzahl);
        }
     }
  
#if 0
  // abschlieender check:
  cout << "mpz_sqrtmod: checking squares" << endl;
  mpz_t x;
  mpz_init(x); mpz_powm_ui(x,res,2,Primzahl);
  if (mpz_cmp(x,Radikant)!=0)
   {
     cerr << "Wurzelberechnung fehlgeschlagen!" << endl;
     cerr << Radikant << "," << x << endl;
     exit(1);
   }
  mpz_clear(x);
#endif

  mpz_clear(Radikant);
}

