/*! @file
 * @brief
 * contains some of the simplier factoring algorithms
 */


void pollard(const int runden) /* Pollard-rho-Methode */
{
  cout << "Trying Pollard-rho up to " << runden << endl;
  mpz_t a,a2,x;
  mpz_init(a); mpz_init(a2); mpz_init(x);
  mpz_set_ui(a,1); mpz_set(a2,a);
  
  for (int i=1; i<=runden; i++)
   {
#ifdef REACT_ON_SIGUSR
     if (USRSignalHandler.got_SIGUSR1()) break;
     if (USRSignalHandler.got_SIGUSR2()) break;
#endif
     mpz_mul(a,a,a); mpz_add_ui(a,a,1); mpz_mod(a,a,n);
     mpz_mul(a2,a2,a2); mpz_add_ui(a2,a2,1); mpz_mod(a2,a2,n);
     mpz_mul(a2,a2,a2); mpz_add_ui(a2,a2,1); mpz_mod(a2,a2,n);
     mpz_sub(x,a2,a);
     mpz_gcd(x,x,n);
     while (mpz_cmp_ui(x,1)!=0)
      {
        if (mpz_cmp(x,n)==0) { cout << "trivial factor in round " << i << endl; continue; }
        unsigned int exp=mpz_remove(n,n,x); // alle Vorkommen abdividieren
        if (mpz_probab_prime_p(x,probab_prime_checks))
	 {
	   cout << x << " is factor. [round " << i <<"]" << endl;
	   Factorization_to_file << MAL(x,exp) << flush;
	 }
	else
	 {
	   cout << x << " is a composite factor. [round " << i <<"]" << endl;
	   Factorization_to_file << MAL(x,exp) << " [rho/composite]" <<  flush;
	 }
        if (mpz_probab_prime_p(n,probab_prime_checks)) goto fertig; /* Rest wahrscheinlich prim */
	mpz_gcd(x,x,n); // possible case: x=p*q and n=p*q*q*r -> second q would not be found!
      }
   };
fertig:
  mpz_clear(a); mpz_clear(a2); mpz_clear(x);
}

bool try_memorized_factors(mpz_t n, const string& memfilename)
{
  // trial division by some factors given in a file...
  bool reduced = false;

  ifstream in(memfilename.c_str());
  if (in)
    {
      cout << "Trial division by factors in " << memfilename << endl; 
      mpz_t x;
      mpz_init(x);
      while (!in.eof())
	{
          while (isspace(in.peek())) in.get(); // ignore all whitespaces
          if (in.peek()=='#')
           {
             in.ignore(1000,'\n'); // ignore comment lines
	     continue;
           }
	  in >> x;
	  //cout << "try " << x << endl;
	  if (mpz_cmp(n,x)==0) return reduced; // letzter Restfaktor soll in n verbleiben!
	  while (mpz_divisible_p(n,x))
           {
             if (mpz_probab_prime_p(x,probab_prime_checks))
	       {
	         cout << x << " is factor. [memorized]" << endl;
		 Factorization_to_file << MAL() << x << " [memorized]" << flush;
	       }
	     else
	       {
		 cout << x << " is a composite factor. [memorized]" << endl;
		 Factorization_to_file << MAL() << x << " [composite/memorized]" <<  flush;
	       }
	     mpz_divexact(n,n,x); reduced=true;
           }
	  while (isspace(in.peek())) in.get(); // ignore all whitespaces
        }
    } else cerr << memfilename << " inaccessible!" << endl;
 return reduced;
}

#include "pollard_phi.cc"
#include "fibonacci_ppm1.cc"

bool Potenztest(const mpz_t n)
{
  // (reine) Potenzen vorhanden?
  mpz_t y;
  mpz_init(y);
  for (unsigned int k=mpz_sizeinbase(n,256); k>1; k--)
    {
      //cout << "k=" << k << "?" << endl;
      if (mpz_root(y,n,k))
	{
	  cout << y << "^" << k <<  " is ";
	  Factorization_to_file << MAL(y,k);
	  if (!mpz_probab_prime_p(y,probab_prime_checks))
	    {
	      cout << "composite ";
	      Factorization_to_file << " [composite power]";
	    }
	  Factorization_to_file << flush;
	  cout << "factor." << endl;
	  mpz_clear(y);
	  return true; 
	}
    }
  mpz_clear(y);
  return false; // ein Fall fr Viagra...
}


#include "fermat.cc"

void easy_factor()
{
  /* einfache Faktorisierung versuchen:
     vielleicht kann die Zahl dadurch komplett faktorisiert werden
     oder zumindest um einige Faktoren reduziert werden... */

  if (!SkipFermat) fermat_like_methode();
  /* Fermat-hnliche Faktorisierung versuchen fr den Fall, da die Zahl
     z.B. die Form (a-d)*(a+d) mit kleinem d hat... */
  
  const unsigned long int Obergrenze_Easy = 1000000;
  cout << "Trialdivision up to " << Obergrenze_Easy << endl;
  const unsigned int some_primes [] = { 2,3,5,7,11,13,0 };
  unsigned long int p;
  {
    /* Probedivision mit kleinen Primzahlen */
    for (unsigned int index=0; some_primes[index]; ++index)
     {
       p=some_primes[index];
       //cout << "Trial Division with " << p << endl;
       int exp=0;
       while (mpz_divisible_ui_p(n,p)) { mpz_divexact_ui(n,n,p); exp++; }
       if (exp>0)
        {
	  cout << p << "^" << exp << " is factor." << endl;
	  Factorization_to_file << MAL() << p;
          if (exp>1) Factorization_to_file << "^" << exp;
        }
     }
    
    /* Probedivision bis Obergrenze_Easy */
    unsigned int delta;
    if (p%6==1) delta=4;
     else 
      if (p%6==5) delta=2;
      else
       {
         MARK;
         cerr << "Something is wrong with some_primes!" << endl;
         exit(1);
       }
      
    while (p<Obergrenze_Easy)
     {
       p+=delta; delta=6-delta;
       if ( p%5==0 || p%7==0 || p%11==0 || p%13==0 ) continue;
       //cout << "Trial Division with " << p << endl;
       int exp=0;
       while (mpz_divisible_ui_p(n,p)) { mpz_divexact_ui(n,n,p); exp++; }
       if (exp>0)
	 {
	   cout << p << "^" << exp << " is factor." << endl;
	   Factorization_to_file << MAL() << p;
           if (exp>1) Factorization_to_file << "^" << exp;
           if (mpz_cmp_ui(n,1)==0) break; // fertig!
	 }
     } 
    
    Factorization_to_file.flush();
  }

  if (Potenztest(n)) mpz_set_ui(n,1);
  if (mpz_cmp_ui(n,1)==0) goto fertig; 
  if (mpz_probab_prime_p(n,probab_prime_checks)) goto fertig;

  if (try_memorized_factors(n,"fibonacci.factors")) // "gecachte" Faktoren
   {
     if (mpz_probab_prime_p(n,probab_prime_checks)) goto fertig;
   }

  {
    unsigned int dezimalstellen = mpz_sizeinbase(n,10);
    tune_parameters(dezimalstellen);
    pollard(rho_Phase); /* Faktorisierung nach Pollard-Rho-Methode versuchen */

    if (Potenztest(n)) mpz_set_ui(n,1);
    if (mpz_cmp_ui(n,1)==0) goto fertig;
    if (mpz_probab_prime_p(n,probab_prime_checks)) goto fertig;

    if (dezimalstellen != mpz_sizeinbase(n,10))
     {
       dezimalstellen=mpz_sizeinbase(n,10);
       tune_parameters(dezimalstellen);
     }

#if 1
   if (dezimalstellen>200)
    {
      // number seems to be very large
      // if it partly contains fibonacci factors, we should try to split it
      // here to save time.  (Since I'm trying to factor some fibonacci &
      // lucas numbers, this test is implemented.)
      fibonacci_ppm1(100000,0); /* Fibonacci (p+-1)-Methode */
      if (dezimalstellen != mpz_sizeinbase(n,10))
       {
         if (Potenztest(n)) mpz_set_ui(n,1);
         if (mpz_cmp_ui(n,1)==0) goto fertig;
         if (mpz_probab_prime_p(n,probab_prime_checks)) goto fertig;
         dezimalstellen=mpz_sizeinbase(n,10);
         tune_parameters(dezimalstellen);
       }
    }
#endif


#if 1
    // in the standalone version the mpqs will be quite fast in finding
    // small factors, so we do not need to run ecm on small composite numbers.
    // However, in a networked client-server system, factoring small composite
    // numbers causes too much overhead and is therefore annoying...
#ifndef IS_SERVER
    if (rho_Phase>=100000 && mpz_sizeinbase(n,10)>70)
#endif
     {
       // mini-ecm: try a few elliptic curves just to eliminate some small numbers
       // in the range up to let's say 10-20 digits.
       // This is especially advantageous for composite Fibonacci-
       // and Lucasnumbers, because fibfactor has the chance to find the
       // remaining cofactors!
       for (int i=0; i<10; ++i)
        {
          elliptic_curves elliptic_curve; // Instanz der Kurve kreieren
          elliptic_curve.go(7+i,60000,15000000); /* Faktorisierung mit elliptischer Kurve versuchen */

          if (dezimalstellen != mpz_sizeinbase(n,10))
           {
             if (Potenztest(n)) mpz_set_ui(n,1);
             if (mpz_cmp_ui(n,1)==0) goto fertig;
             if (mpz_probab_prime_p(n,probab_prime_checks)) goto fertig;
             dezimalstellen=mpz_sizeinbase(n,10);
             tune_parameters(dezimalstellen);
           }
        }
     }
#endif


#if 1
    if (SkipPhi || (phi_Phase1<=0 && phi_Phase2<=0))
     cout << "Phi-Phase is deactivated!" << endl;
    else
     {
       pollard_phi(phi_Phase1,phi_Phase2); /* Faktorisierung nach Pollard-Phi-Methode versuchen */
       if (dezimalstellen != mpz_sizeinbase(n,10))
        {
          if (Potenztest(n)) mpz_set_ui(n,1);
          if (mpz_cmp_ui(n,1)==0) goto fertig;
          if (mpz_probab_prime_p(n,probab_prime_checks)) goto fertig;
          dezimalstellen=mpz_sizeinbase(n,10);
          tune_parameters(dezimalstellen);
        }
     }
#endif

    if (SkipFibonacci || (phi_Phase1<=0 && phi_Phase2<=0))
     cout << "Fibonacci-Phase is deactivated!" << endl;
    else
     {
       fibonacci_ppm1(phi_Phase1,phi_Phase2); /* Fibonacci (p+-1)-Methode */
       if (dezimalstellen != mpz_sizeinbase(n,10))
        {
          if (Potenztest(n)) mpz_set_ui(n,1);
          if (mpz_cmp_ui(n,1)==0) goto fertig;
          if (mpz_probab_prime_p(n,probab_prime_checks)) goto fertig;
          dezimalstellen=mpz_sizeinbase(n,10);
          tune_parameters(dezimalstellen);
        }
     }
  }

fertig:  
  cout << "remaining number:" << endl << n << endl;
  
  if ( (mpz_cmp_ui(n,1)==0) || Potenztest(n) )
    {
      Factorization_to_file << endl;
      exit(0); /* 1 als Faktor: komplett faktorisiert */
    }  

  if (mpz_probab_prime_p(n,probab_prime_checks))
    {
      Factorization_to_file << MAL() << n << endl;
      cout << "remaining number is most probably a prime!" << endl;
      exit(0);
    }
//Factorization_to_file << " * " << n << " [REST]" << endl; exit(0);
}
