void bestes_kN_ermitteln()
{
  // es ist gnstig, mglichst viele kleine Primfaktoren in der Faktorbasis
  // zu haben. Hierfr kann man die zu faktorisierende Zahl mit einem kleinen
  // Vorfaktor (der am besten prim sein sollte) multiplizieren, um andere
  // Faktorbasen zu erhalten..
  // Welches ein gnstigster Vorfaktor ist, wird hier ermittelt.
  // Die zugehrigen globalen Variablen werden entsprechend angepat:
  // Vorfaktor_von_kN = <ermittelter Vorfaktor>
  // kN = Vorfaktor_von_kN*n sowie r = trunc(sqrt(kN))

  /* Bemerkung: Fr diese Implementierung des multipolynomialen Siebs ist es zustzlich
     erforderlich, da kN=1 (mod 4).
     Besser noch ist kN=1 (mod 8), wenn auch 2 in der Faktorbasis sein soll.
     (vgl. Paper von Silverman) */

  // Hier nun eine eigene Vorfaktorermittlung:
  const int P=2; /* grte Primzahl, bis zu der (einschlielich und mindestens) die Primzahlen
		    in der Faktorbasis aufeinanderfolgende Primzahlen sind.
		    Mindestwert fr P ist 2. */
  int Schranke_k = 250; /* maximal die ersten bis zum Vorfaktor Schranke_k den Test
			      durchfhren. (Whrend des Tests wird diese Schranke dann
			      hchstens noch verkleinert.) */
  const int FB_SIM_Size = 2000; /* Faktorbasisgre, mit der Simulation durchgefhrt werden soll. */
  
  // 1. Es sollen alle Primzahlen von 2 bis P in der statischen Faktorbasis enthalten sein.
  //    Dafr wird in Kauf genommen, da der Vorfaktor etwas grer wird...
  // 2. Maximal bis "Schranke_k" wird fr Vorfaktoren simuliert, wie gut diese Vorfaktoren abschneiden.
  //    Hierfr werden Teilbarkeitswahrscheinlichkeiten verwendet und die Grenordnung
  //    der zu siebenden Zahl anhand des Vorfaktors bercksichtigt.
  // 3. Wird ein neuer besserer Vorfaktor entdeckt, dann wird "Schranke_k" neu kalkuliert.
  // 4. Der hierbei am besten abschneidende Vorfaktor wird schlielich verwendet.
  
  cout << "Ermittlung des Multipliers." << endl;

  if (mpz_sizeinbase(n,10)<35)
   Schranke_k=100; // fr kleine Zahlen begrenzen, da sonst die Vorfaktorermittlung lnger als Faktorisierung dauert...
  
  // zunchst die theoretisch (erreichbare) optimale Faktorbasis als Berechnungsgrundlage
  // fr Optimalwert ermitteln:
  double optimal_w, good_w;
  int p; // fr Primzahltest
  
  p=2; optimal_w= -2*log(2);
  int z=2;
  while (p<P)
    { 
      while (!is_prime(p)) p++;
      {
	int pp = p;
	if (z<sieben_ab_Primzahlindex) { optimal_w -= 0.0*2*log(p)/p; pp*=p; } 
	while (pp<=2*M/pp)
	  {
	    optimal_w -= 2*log(p)/pp;
	    pp*=p;
	  }
      }
      p++; z++;
    }
  // bis hierher alle Primzahlen in Folge in simulierter FB
  // fr theoretisch optimale FB mssen smtliche Primzahlen in Folge in FB liegen
  for (; z<FB_SIM_Size; p++)
    { 
      while (!is_prime(p)) p++;
      z++;
      {
	int pp = p;
	if (z<sieben_ab_Primzahlindex) { optimal_w -= 0.0*2*log(p)/p; pp*=p; } 
	while (pp<=2*M/pp)
	  {
	    optimal_w -= 2*log(p)/pp;
	    pp*=p;
	  }
      }
    }

  // Nun noch eine realistischere Bewertungsgrundlage:
  good_w=0.85*optimal_w;
  
  cout << "Theoretisch optimale Simulationsbewertung: " << setprecision(10) << optimal_w << endl;
  cout << "Theoretisch gute Simulationsbewertung: " << good_w << endl; 
  cout << "Starte Vorfaktorsimulation..." << endl;
  
  // ab hier die "wirkliche" Vorfaktorermittlung

  // Besonderheit: Dirty-Sieving wird simuliert, d.h.
  // fr die ersten "sieben_ab_Primzahlindex" Primzahlen wird
  // die Trefferwahrscheinlichkeit vermindert.  


  // Feld fr sortierte Aufnahme der "sort_bis"+1 besten Vorfaktoren
  struct tFeldeintrag { double w; int k; };
  const short int sort_bis = 5;    
  tFeldeintrag Feld[sort_bis]; /* Feld wird automatisch mit Nullen initialisiert
				  -> fr Bewertung werden daher grundstzlich
				  negative Werte vorausgesetzt */

  double best_w = 1e20;
  double akt_w;
  int best_k = 1;
  int k=1; // testweiser Vorfaktor
  z=0; // Index der Primzahl in der Faktorbasis 
  
  while (k<=Schranke_k)
    {
      mpz_mul_ui(kN,n,k); /* kN initialisieren */
      
      // ist 2 in der Faktorbasis?
      //if (mpz_mod_ui(x,kN,8)!=1) goto next;
      if (!mpz_congruent_ui_p(kN,1,8)) goto next;

      akt_w=-2*log(2); // Initialisierung der Bewertung fr neuen Vorfaktor
      
      p=2; z=1;
      while (p<P)
	{
	  do p++; while(!is_prime(p));
	  mpz_set_ui(x,p); if (mpz_legendre(kN,x)==-1) goto next; // goto next -> Vorfaktor verwerfen
          z++;

	  // Aktualisierung der Bewertung:
	  if (k%p==0) akt_w -= (z<sieben_ab_Primzahlindex) ? 0.0*log(p)/p : log(p)/p;
	  else
	    {
	      int pp = p;
	      if (z<sieben_ab_Primzahlindex) { akt_w -= 0.0*2*log(p)/p; pp*=p; } 
	      while (pp<=2*M/pp)
		{
		  akt_w -= 2*log(p)/pp;
		  pp*=p;
		}
	    }
	  
	}
      
      // Vorfaktor prinzipiell geeignet, nun noch weiter bewerten:
      {
	for ( ; z<FB_SIM_Size; z++)
	  {
	    do
	      {
		do p++; while(!is_prime(p)); /* nchste Primzahl */
		mpz_set_ui(x,p);
	      }
	    while (mpz_legendre(kN,x)==-1); // Primzahl gltig fr Primzahlbasis?


	    // Aktualisierung der Bewertung:
	    if (k%p==0) akt_w -= (z<sieben_ab_Primzahlindex) ? 0.0*log(p)/p : log(p)/p;
	    else
	      {
		int pp = p;
		if (z<sieben_ab_Primzahlindex) { akt_w -= 0.0*2*log(p)/p; pp*=p; } 
		while (pp<=2*M/pp)
		  {
		    akt_w -= 2*log(p)/pp;
		    pp*=p;
		  }
	      }
	    
	  }

	akt_w += 0.5*log(k); // Threshold addieren
	
        // nun noch den Vorfaktor mit Bewertung ausgeben
	cout << k << " mit Bewertung " << akt_w << endl;

	{ 
          // in diesem Block werden zu Informationszwecken die fnf besten
          // Vorfaktoren gesammelt:
          short signed int i=sort_bis-1;
          if (akt_w<Feld[i].w)
	    {
              while (i>0 && akt_w<Feld[i-1].w) { Feld[i]=Feld[i-1]; --i; }
              Feld[i].w=akt_w; Feld[i].k=k;
            }
	}
        
	if (akt_w<best_w)
	  {
	    cout << "bisher bester Vorfaktorvorschlag " <<  k 
                 << " mit Bewertung " << akt_w << endl;
	    best_w=akt_w; best_k=k;
	    int berechnete_Schranke_k;
	    if (akt_w>good_w)
                 berechnete_Schranke_k = static_cast<int>(ceil(exp(2*(akt_w-good_w))));
	    else berechnete_Schranke_k = 0;
	    if (berechnete_Schranke_k>=0 && berechnete_Schranke_k<Schranke_k)
	      Schranke_k=berechnete_Schranke_k;
	    cout << "Neue Schranke: " << Schranke_k
                 << " (berechnet: " << berechnete_Schranke_k << ")" <<  endl;
	  }
      }
      
      
    next: // nchsten Vorfaktor holen
#if 0
      do k++; while(!is_prime(k)); // falls nur Primzahlen Vorfaktoren sein sollen
#else
      // alternativ: Vorfaktor beliebige (positive natrliche) quadratfreie Zahl
      k++;
      { // ist k quadratfrei?
        int square=4, i=5;
        while (square<=k)
	  {
            if (k%square==0) goto next; // enthlt Quadrat
            square+=i; i+=2;
	  }
	// okay, k ist quadratfrei...
      }
#endif
    }
  cout << endl;

  cout << "Ausgabe der " << sort_bis << " besten Multiplier:" << endl;
  for (short int i=0; i<sort_bis; i++)
    cout << i+1 << ". " << Feld[i].k << " mit " << Feld[i].w << endl;
  cout << endl;
 
#if 1
  // Falls dieser Block aktiviert ist, kann nun "interaktiv" 
  // ein Multiplier eingetippt werden 
  cout << "Bitte geben Sie einen Vorfaktor ein: ";
  cin >> best_k;
  //collecting_phase_beendet = true; // keine dynamischen Faktoren
#endif

  Vorfaktor_von_kN=best_k; // Vorfaktor global zugnglich machen
  cout << "Multiplikator fr Sieb ist " << best_k << endl;
  mpz_mul_ui(kN,n,best_k); /* bestes kN (erneut) berechnen */
  mpz_sqrt(r,kN); /* Quadratwurzel von kN ermitteln */
  cout << r << " ist trunc(sqrt(kN))" << endl;
}
