/*! @file
 * @brief
 * implemantation of base class used in DLP-MPQS
 */


// static class members
double CmpqsFactor::rejected_dlp_counter = 0.0;
mpz_t CmpqsFactor::DLP_Threshold; // Double-Large-Prime-Threshold (wird in main() gesetzt)


// benutze Pollard-rho zum Faktorisieren der Double-Large-Primes
const bool CmpqsFactor::DLP_get_using_pollard_rho(const mpz_t n)
{
  if (mpz_cmp(n,DLP_Threshold)>0)
   {
     //cout << "DLP_get: Threshold berschritten..." << endl;
     return false;
   }

  int runden=50000; // Anzahl der Pollard-rho-Runden, die maximal versucht werden
  // Hinweis: viele Runden kosten Zeit, wenige Runden senken die Erkennungsrate

  mpz_t x,a,a2;
  mpz_init_set(x,n); mpz_init(a); mpz_init(a2);
  mpz_set_ui(a,1); mpz_set(a2,a);

  p1=0; p2=0; // Vorbesetzung

  do
    {
     
      mpz_mul(a,a,a); mpz_add_ui(a,a,1); mpz_mod(a,a,n);
      mpz_mul(a2,a2,a2); mpz_add_ui(a2,a2,1); mpz_mod(a2,a2,n);
      mpz_mul(a2,a2,a2); mpz_add_ui(a2,a2,1); mpz_mod(a2,a2,n);
      mpz_sub(x,a2,a);
      mpz_gcd(x,x,n);
    } while (--runden && mpz_cmp_ui(x,1)==0);
  if (mpz_cmp_ui(x,1)!=0)
    {
      // nun prfen, ob beide Teiler prim sind und klein genug sind
      if (mpz_cmp_ui(x,Specialfactor_Sieb_Threshold)>=0) goto fertig;
      p1=mpz_get_ui(x);
      mpz_divexact(a,n,x);
      if (mpz_cmp_ui(a,Specialfactor_Sieb_Threshold)>=0) goto fertig;
      p2=mpz_get_ui(a);
      // Hinweis: wenn man hier nicht auf Primzahlen prft, dann mu man
      //          es spter bei der Abspaltung eines Faktors tun!
      //          Also machen wir es hier schon...
      if (!numtheory::probab_prime(p1)) { p1=0; goto fertig; }
      if (!numtheory::probab_prime(p2)) { p2=0; goto fertig; }
      if (p1>p2) std::swap(p1,p2);
    };
fertig:
  mpz_clear(a); mpz_clear(a2); mpz_clear(x);
  //if (runden==0) cout << "DLP_get: Runden ausgeschpft." << endl;
  cout << "DLP_get: (" << 50000-runden << ") " << p1 << "," << p2 << endl;
  
  //static unsigned int runden_ges = 0;
  //runden_ges+=50000-runden;
  //cout << "DLP_get: bisherige Runden: " << runden_ges << endl;

  return (p1!=0 && p2!=0);
}


// benutze Shank's square forms factorization zum Faktorisieren der Double-Large-Primes
const bool CmpqsFactor::DLP_get(const mpz_t n)
{
  const unsigned int runden = 50000; // Anzahl der Runden, die maximal versucht werden
  // Hinweis: viele Runden kosten Zeit, wenige Runden senken die Erkennungsrate

  mpz_t mx,mr;
  mpz_init(mx); mpz_init(mr);

  p1=0; p2=0; // Vorbesetzung
  unsigned int SQUFOF_Vorfaktor = 1; // we assume this to be 1 or a very small prime number!

try_new_Vorfaktor:
  if (SQUFOF_Vorfaktor==1) mpz_sqrtrem(mx,mr,n);
  else
   {
     mpz_mul_ui(mx,n,SQUFOF_Vorfaktor);
     mpz_sqrtrem(mx,mr,mx);
   }
  const unsigned int sq = mpz_get_ui(mx);
  const unsigned int d = mpz_get_ui(mr);
  mpz_mul_ui(mx,mx,2); mpz_add_ui(mx,mx,1); mpz_sqrt(mx,mx);
  const unsigned int sq2sqN = mpz_get_ui(mx);

  unsigned int lindex=0;
  const unsigned int bound = 60;
  unsigned int list[bound];
  bool square_found=false;

  unsigned int Q,P2,Q2;
  unsigned int r=0, Q0=1, P1=sq, Q1=d;
  unsigned int runde1=0, runde2=0;

  if (d==0)
   {
     // perfect square!!
     p1=p2=sq; goto fertig;
   }

  for (runde1=1; runde1<runden; ++runde1)
   {
     //cout << "Runde" << runde1 << endl;
     Q=(sq+P1)/Q1;
     P2=sq-((sq+P1)%Q1); // equivalent to P2=Q*Q1-P1, but "/" and "%" probably use the same cpu instruction!
     if (P1>=P2) Q2=Q0+Q*(P1-P2); else Q2=Q0-Q*(P2-P1);

     // "unsigned int" has one more bit than "signed int", so overflows
     // should not occur at all,
     // but therefore now we have to take care for the sign!
     // Anyway: seldom overflows will cause no harm at all,
     // they only waste computing time (resulting in pollard rho doing
     // the job again...)
     // -> see below: "this line shouldn't be..."

     const unsigned int u = (Q1&1) ? Q1 : Q1>>1;
     Q0=Q1; Q1=Q2; P1=P2;
     if (u<sq2sqN && u>1)
      {
        list[lindex++]=u; 
        if (lindex>=bound)
         {
           cout << "SQUFOF: Liste luft ber..." << endl;
           break;
         }
      }
     if (runde1&1)
      {
        if ((Q1&3)>1)
          continue; // kein Quadrat
        if ((Q1&7)==5 || (Q1&9)==8)
          continue; // ebenfalls kein Quadrat
        r=static_cast<unsigned int>(sqrt(Q1)); if (Q1!=r*r) continue; // kein Quadrat
        bool fl=false;
        for (unsigned int k=0; k<lindex; ++k)
         if (r==list[k]) { fl=true; break; }
        if (fl) continue; // Square not useful
        square_found=(r>1); break;
      }
   }

  if (!square_found)
   {
     //cout << "DLP-SQUFOF, Vorfaktor " << SQUFOF_Vorfaktor << ": No success." << endl;
     if (SQUFOF_Vorfaktor==1) { SQUFOF_Vorfaktor=2; goto try_new_Vorfaktor; }
     if (SQUFOF_Vorfaktor==2) { SQUFOF_Vorfaktor=3; goto try_new_Vorfaktor; }
     cout << "DLP-SQUFOF: Fallback to pollard rho method." << endl;
     DLP_get_using_pollard_rho(n);
     goto fertig;
   }

  //cout << "DLP-SQUFOF: square found in round " << runde1 << endl;

  double DQ,DQ0,DQ1,DQ2,DP1,DP2;
  mpz_set_ui(mr,P1); mpz_mul_ui(mr,mr,P1);

  if (SQUFOF_Vorfaktor==1) mpz_sub(mx,n,mr);
  else { mpz_mul_ui(mx,n,SQUFOF_Vorfaktor); mpz_sub(mx,mx,mr); }
  mpz_div_ui(mx,mx,r);
  DQ1=mpz_get_d(mx);
  DQ0=r; DP1=P1;

  for (runde2=1; runde2<runden; ++runde2)
   {
     DQ=floor((sq+DP1)/DQ1); DP2=DQ*DQ1-DP1;
     DQ2=DQ0+DQ*(DP1-DP2); DQ0=DQ1; DQ1=DQ2;
     if (DP1==DP2)
      {
        // factor found
        if ((DQ0/2)==floor(DQ0/2)) DQ0/=2;
        if ( SQUFOF_Vorfaktor>1 && (DQ0/SQUFOF_Vorfaktor)==floor(DQ0/SQUFOF_Vorfaktor) ) DQ0/=SQUFOF_Vorfaktor;

        if (DQ0==1.0)
         {
           //cerr << "DLP-SQUFOF: Vorfaktor rediscovered; falling back to pollard rho..." << endl;
           DLP_get_using_pollard_rho(n); goto fertig;
         }

        // nun prfen, ob beide Teiler prim sind und klein genug sind

        if (DQ0>=Specialfactor_Sieb_Threshold) goto fertig;
        p1=static_cast<unsigned int>(DQ0);
        if (mpz_div_ui(mx,n,p1)) { cerr << "DLP_get-SQUFOF: Teiler mit Rest??" << endl; exit(1); }
        if (mpz_cmp_ui(mx,Specialfactor_Sieb_Threshold)>=0) goto fertig;
        p2=mpz_get_ui(mx);
        // Hinweis: wenn man hier nicht auf Primzahlen prft, dann mu man
        //          es spter bei der Abspaltung eines Faktors tun!
        //          Also machen wir es hier schon...
        if (!numtheory::probab_prime(p1)) { p1=0; goto fertig; }
        if (!numtheory::probab_prime(p2)) { p2=0; goto fertig; }
        if (p1>p2) std::swap(p1,p2);
        //cout << "DLP-SQUFOF: Faktorisierung gefunden!" << endl;
        goto fertig;
      }
     DP1=DP2;
   }
  MARK;
  cerr << "This line should'nt be executed!!! Overflow in unsigned int?? Negative Values??" << endl;
  DLP_get_using_pollard_rho(n); // fallback...

fertig:
  mpz_clear(mx); mpz_clear(mr);

#ifdef VERBOSE
  cout << "DLP_get (SQUFOF): (" << runde1 << "," << runde2 << ") "
       << p1 << "," << p2 << endl;
#endif

#if 1 /* some statistics */
 static double good_dlp_counter = 0.0;
 static double bad_dlp_counter  = 0.0;
 if (p1&&p2) good_dlp_counter+=1.0; else bad_dlp_counter+=1.0;
 static time_t lastout = 0;
 if (time(NULL)>lastout+60)
  {
    lastout=time(NULL);
    cout << "DLP-SQUFOF: "
         << setw(6) << setprecision(5)
         << 100.0*rejected_dlp_counter/(rejected_dlp_counter+good_dlp_counter+bad_dlp_counter)
         << "% of DLP-candidates were rejected!" << endl;
    cout << "DLP-SQUFOF: "
         << setw(10) << setprecision(0) << good_dlp_counter 
         << " [" << setw(6) << setprecision(5)
         << 100.0*good_dlp_counter/(good_dlp_counter+bad_dlp_counter)
         << "%] of non-rejected DLP are good!" << endl;
  }
#endif

  return (p1&&p2);
}


istream& operator>> (istream &istr, CmpqsFactor &x)
{
   char s[50];
   istr >> setw(sizeof(s)) >> s;
   x.p1=0; x.p2=0;
   int i=0;
   while (s[i]!=0 && s[i]!='*') ++i;
   if (s[i]==0) 
    {
      x.p1=0; x.p2=atoi(s);
      //cout << "DLP: ein Wert eingelesen" << endl;
    }
   else 
    if (s[i]=='*')
     {
       s[i]=0;
       x.p1=atoi(s);
       x.p2=atoi(&s[i+1]);
       //cout << "DLP: zwei Werte eingelesen" << endl;
     }
    else
     {
       cerr << "Fehler beim Einlesen DLP!" << endl;
     }
   //cout << "DLP:" << x.p1 << "*" << x.p2 << endl;
   return istr;
}
