#ifndef CmpqsFactor_header
#define CmpqsFactor_header

/*! @file
 * @brief
 * header file for declaration of base class used in DLP-MPQS
 */


class CmpqsFactor
{
 public:
  enum Factortype { empty, static_prime, single_large_prime, double_large_prime };
 private:
  unsigned int p1,p2; // mit p1<=p2
  static double rejected_dlp_counter;
 public:
  static mpz_t DLP_Threshold; // Double-Large-Prime-Threshold (wird in main() gesetzt)
  static inline const bool DLP_rejected(const mpz_t n)
   {
     if (mpz_cmp(n,DLP_Threshold)>0)
      {
        rejected_dlp_counter+=1.0;
        return true;
      }
      // also reject probably primes (but do not count them)
      return mpz_probab_prime_p(n,10)!=0;
   }
  const bool DLP_get_using_pollard_rho(const mpz_t n); // is somewhat slower than SQUFOF!
  const bool DLP_get(const mpz_t n); // using SQUFOF (with fallback to pollard rho)

  inline CmpqsFactor operator= (const unsigned int x)
   { p1=0; p2=x; return *this; }

  inline int int_value() const
   {
     // liefert int-Wert zurck (oder Fehlermeldung)
     if (p1)
      {
       cerr << "Kann int nicht zwei Werte zuweisen!" << endl;
       exit(1);
       return 0;
      }
     return p2;
   }
  inline int LP1() const { return p1; }
  inline int LP2() const { return p2; }
  inline void set_for_search(const unsigned int x)
   { 
     // invers sortiert einfgen, um nach x suchen zu knnen
     p1=x; p2=0;
   }
  inline void swap(void) { unsigned int h=p1; p1=p2; p2=h; }
  inline void in_mpz_ablegen(mpz_t x) const
   {
     if (p1==0) { mpz_set_ui(x,p2); return; }
     if (p2==0) { mpz_set_ui(x,p1); return; }
     mpz_set_ui(x,p1); mpz_mul_ui(x,x,p2);
   }
  inline Factortype Typ() const
   {
     if (p1>p2)
      { cerr << "CmpqsFactor: unsortierte Faktoren!" << endl; }
     if (p1==0 && p2==0) return empty;
     if (p1==0 && p2==1) return static_prime;
     if (p1==0) return single_large_prime;
     return double_large_prime;
   }
  inline bool DLP_enthaelt_Teiler(const unsigned int x) const
   { return p1==x || p2==x; }
  inline bool operator< (const CmpqsFactor &x) const
   {
     if (p1==x.p1) return p2<x.p2;
     else return p1<x.p1;
   }

  inline const bool operator== (const CmpqsFactor &x) const
   {
     return (p1==x.p1 && p2==x.p2); // komponentenweise Identitt
   }
  inline const bool operator!= (const CmpqsFactor &x) const { return !((*this)==x); }

  friend ostream& operator<< (ostream &ostr, const CmpqsFactor &x);
  friend istream& operator>> (istream &istr, CmpqsFactor &x);
  const int operator/ (const unsigned int u) const;
};

inline const int CmpqsFactor::operator/ (const unsigned int u) const
{
  // Diese "Divisionsoperation" liefert den durch u abgespaltenen
  // (also den anderen) Faktor zurck
  if (p1==u) return p2;
  if (p2==u) return p1;
  cerr << "CmpqsFactor: invalid division!" << endl;
  exit(1);
  return 0;
}

inline ostream& operator<< (ostream &ostr, const CmpqsFactor &x)
{
   if (x.p1) ostr << x.p1 << "*" << x.p2;
   else ostr << x.p2;
   return ostr;
}

#endif
