// SQUFOF
//
/* Reference:
   Riesel, Hans: Prime numbers and computer methods for factorization,
   Boston, Basel, 1985, p. 195ff.
*/
//
// written by Thorsten Reinecke (02.04.1999)
// last change: 03.04.1999


#include <iostream.h>
#include <iomanip.h>
#include <math.h>

unsigned int squfof(long double n)
{
  int sq = sqrt(n);
  long double dd = n-(long double)(sq)*(long double)(sq);
  int d=dd;

  if (d==0) return sq;

  int sq2sqN = sqrt(2*sq+1);

  cout << sq << "," << d << "," << sq2sqN << endl;
  //char ch; cin >> ch;

  int lindex=0;
  const int bound = 100;
  int list[bound];
  bool square_found=false;

  int Q,P2,Q2;
  int r=0, Q0=1, P1=sq, Q1=d;
  int runde;

  for (runde=1; runde<1000000; ++runde)
   {
     //cout << "Runde" << runde << endl;
     Q=(sq+P1)/Q1; P2=Q*Q1-P1; Q2=Q0+Q*(P1-P2);
     //cout << " Q:" << Q << " Q1:" << Q1 << " Q2:" << Q2
     //     << " P1:" << P1 << " P2:" << P2 << endl;
     //char ch; cin >> ch;
     int u=Q1; if ((u&1)==0) u>>=1;
     Q0=Q1; Q1=Q2; P1=P2;
     //cout << runde << ": " << u << endl;
     if (u<sq2sqN && u>1)
      {
        cout << runde << ": " << u << endl;
        list[lindex++]=u; 
        if (lindex>=bound)
         {
           cout << "Liste luft ber..." << endl;
           break;
         }
      }
     if (runde&1)
      {
        //cout << "Q1:" << Q1 << endl;
        if ((Q1&3)>1) continue; // kein Quadrat
        if ((Q1&7)==5 || (Q1&9)==8) continue; // ebenfalls kein Quadrat
        r=sqrt(Q1); if (Q1!=r*r) continue; // kein Quadrat
        bool fl=false;
        for (int k=0; k<lindex; ++k)
         if (r==list[k]) { fl=true; break; }
        if (fl) { cout << "Square not useful..." << endl; continue; }
        if (r>1) { square_found=true; break; }
        cout << "A Kein Erfolg gehabt..." << endl;
        return 0;
      }
   }

  if (!square_found)
   {
     cout << "B Kein Erfolg gehabt..." << endl;
     return 0;
   }

  cout << "Square gefunden in Runde " << runde << endl;

  Q0=r;
  dd=(n-(long double)(P1)*(long double)(P1))/r;
  cout << "Q0: " << Q0 << " r: " << r << " dd: " << dd << endl;

  double DQ1=dd, DQ0=r, DP1=P1;

  double DQ,DQ2,DP2;

  for (runde=1; runde<500000; ++runde)
   {
     DQ=floor((sq+DP1)/DQ1); DP2=DQ*DQ1-DP1;
     //cout << DP1 << "," << DP2 << endl;
     DQ2=DQ0+DQ*(DP1-DP2); DQ0=DQ1; DQ1=DQ2;
     if (DP1==DP2)
      {
        if ((DQ0/2)==floor(DQ0/2)) DQ0/=2;
        cout << "Faktor gefunden..." << endl;
        return DQ0;
      }
     DP1=DP2;
   }
  return 1;
}

int main()
{
  long double zahl;
  cout << "Faktorsplitting fr kleine Zahlen (2 unsigned int)" << endl;
  cout << "(Keine Garantie fr Primfaktoren!)" << endl;
  cout << setprecision(20) << "Bitte geben Sie eine Zahl ein: ";
  cin >> zahl;
  unsigned int f=squfof(zahl);
  if (f<2) return 1;
  cout << f << " ist Faktor." << endl;
  zahl/=f;
  cout << zahl << " ist Faktor." << endl;
  return 0;
}
