// some Modulo-Operations for double size unsigned int
// written by Thorsten Reinecke (29.03.1999)
// last change: 21.04.1999


#include <iostream.h>


typedef unsigned int uint;
const unsigned char hbit=31; // #bits-1 of unsigned int

// double size unsigned int (dsuint) in explizitem lo/hi-uint-Format.


// es folgen einige Makros
// zunchst i386 inline-assembler-Makros
#ifdef ASM386
#define shiftleft(al,ah) asm("shll $1,%0; rcll $1,%1": "+g" (al), "+g" (ah));
#define shiftright(al,ah) asm("shrl $1,%1; rcrl $1,%0": "+g" (al), "+g" (ah));
#define add(al,ah,bl,bh) asm("addl %2,%0; adcl %3,%1" \
 : "+r" (al), "+r" (ah) : "g" (bl), "g" (bh));
#define sub(al,ah,bl,bh) asm("subl %2,%0; sbbl %3,%1" \
 : "+r" (al), "+r" (ah) : "g" (bl), "g" (bh));
#define subifgreaterequal(al,ah,bl,bh) \
 asm("subl %2,%0; sbbl %3,%1; jae 1f\n\t" \
     "addl %2,%0; adcl %3,%1\n" \
     "1:\n" \
 : "+r" (al), "+r" (ah) : "g" (bl), "g" (bh));
#define shiftright_till_odd_or_zero(al,ah) \
 asm("bsfl %0,%%ecx # position of first set bit in %0 to %%ecx\n\t" \
     "jz 1f # no bit set?\n\t" \
     "shrdl %%cl,%1,%0; shrl %%cl,%1 # shifting right %%ecx-bits\n\t" \
     "jmp 2f # fertig\n" \
     "1: # alle Bits in %0 sind null\n\t" \
     "xchgl %0,%1; bsfl %0,%%ecx; jz 2f\n\t" \
     "shrl %%cl,%0\n" \
     "2:" \
 : "+g" (al), "+g" (ah) : : "ecx");
#else
// und hier die c++-Entsprechungen:
#define shiftleft(al,ah) { ah<<=1; ah|=al>>hbit; al<<=1; }
#define shiftright(al,ah) { al>>=1; al|=ah<<hbit; ah>>=1; }
#define add(al,ah,bl,bh) { al+=bl; ah+=bh+(al<bl); }
#define sub(al,ah,bl,bh) { ah-=bh+(bl>al); al-=bl; }
#define subifgreaterequal(al,ah,bl,bh) \
  { if (ah>bh || (ah==bh && al>=bl)) sub(al,ah,ml,mh); }
#endif


inline long double show (uint xl, uint xh)
{
  return 65536.0*65536.0*xh+xl;
}

void squaremod(uint &yl, uint &yh, const uint ml, const uint mh)
{
  // assumes a<m !!
  // returns x=(a*b) mod m

  register uint xl=yl, xh=yh;
  // offenbar mu man manche (optimierenden) Compiler zu ihrem Glck zwingen:
  // wenn xl,xh Var-Parameter sind, dann will er sie unbedingt verwenden.
  // Durch die lokalen Register-Variablen xl,xh (und den Var-Parametern yl,yh)
  // kann man ihn dann doch berzeugen, auf Registern zu arbeiten. Die
  // Ergebnisse mssen dann natrlich rckbertragen werden, aber das fllt
  // nicht ins Gewicht.
  // Die Registerverwendung fr xl,xh bringt eine erhebliche Zeitersparnis,
  // da wir mit 6 Registern auskommen, wenn ml/mh memory ist (und der
  // i386 hat zufllig genau 6 geeignete Register zur Verfgung).
 
  register uint al,ah,bl,bh;
  al=bl=xl; ah=bh=xh;
  if (!(bl&1)) xl=xh=0;

  char bits=hbit;
  while (bits--)
   {
    shiftleft(al,ah);
    subifgreaterequal(al,ah,ml,mh);
    bl>>=1;
    if (bl&1) 
     {
       add(xl,xh,al,ah);
       subifgreaterequal(xl,xh,ml,mh);
     }
   }
  while (bh)
   {
    shiftleft(al,ah);
    subifgreaterequal(al,ah,ml,mh);
    if (bh&1) 
     {
       add(xl,xh,al,ah);
       subifgreaterequal(xl,xh,ml,mh);
     }
    bh>>=1;
   }

  yl=xl; yh=xh;
}

unsigned int goodcd(register uint al, uint ah, register uint bl, uint bh)
{
  // returns good (odd) common divisor or zero

//  cout << "goodcd (A) :" << show(al,ah) << "," << show(bl,bh) << endl;

  if ((al|ah)==0) return bh ? 0 : bl;
  //if ((bl|bh)==0) return ah ? 0 : al; // dieser Fall kann in dieser Anwendung (pollard) nicht eintreten

#ifdef ASM386
  shiftright_till_odd_or_zero(al,ah);
  shiftright_till_odd_or_zero(bl,bh);
#else
  while (!(1&al)) shiftright(al,ah);
  while (!(1&bl)) shiftright(bl,bh);
#endif

  while (true)
   {
     if (ah>bh)
      {
        sub(al,ah,bl,bh);
#ifdef ASM386
        shiftright_till_odd_or_zero(al,ah);
#else 
        do shiftright(al,ah) while(!(1&al));
#endif
        continue;
      }
     if (ah<bh) 
      {
        sub(bl,bh,al,ah);
#ifdef ASM386
        shiftright_till_odd_or_zero(bl,bh);
#else 
        do shiftright(bl,bh) while(!(1&bl));
#endif
        continue;
      }
     break;
   }
 // cout << "goodcd (B) :" << show(al,ah) << "," << show(bl,bh) << endl;
  // -> ah==bh
  if (al<=bl)
   {
     if (al==bl) return bh ? 0 : bl;
     ah=bl; bl=al; al=ah; // swap
   }
  // -> b>a
  ah=0; al-=bl;
  do al>>=1; while(!(1&al));
//   cout << "goodcd (C) " << show(al,ah) << "," << show(bl,bh) << endl;

  while (bh)
   {
     if (al>bl) --bh;
     bl-=al;
#ifdef ASM386
     shiftright_till_odd_or_zero(bl,bh);
#else 
     do shiftright(bl,bh) while(!(1&bl));
#endif
   }
  // -> ah==bh==0 -> Werte stehen jetzt in al, bl
//  cout << "goodcd (D): " << al << "," << bl << endl;

  while (true)
   {
    if (al>bl) { al-=bl; do al>>=1; while(!(1&al)); continue; }
    if (al<bl) { bl-=al; do bl>>=1; while(!(1&bl)); continue; }
    return al;
   }
}


unsigned int dsuintpollard(const uint ml, const uint mh)
{
  uint al,ah,bl,bh,cl,ch;
  al=1; ah=0;
  bl=1; bh=0;
  int count = 0;
  do
   {
     count++;
     squaremod(al,ah,ml,mh); ++al; if (!al) ++ah;
     squaremod(bl,bh,ml,mh); ++bl; if (!bl) ++bh;
     squaremod(bl,bh,ml,mh); ++bl; if (!bl) ++bh;
     if (bh>ah || (bh==ah && bl>=al))
      { 
        ch=bh-ah-(al>bl);
        cl=bl-al;
      }
     else
      {
        ch=ah-bh-(bl>al);
        cl=al-bl;
      }
     //cout << count << ": " << show(c) << endl;
   } while (goodcd(cl,ch,ml,mh)==1);
 cout << "Runden: " << count << endl;
 //cout << "Ergebnis: " << goodcd(cl,ch,ml,mh) << endl;
 return goodcd(cl,ch,ml,mh);
}



#include <iomanip.h>

int main()
{
  uint nl,nh;

#if 0
  nl=0; nh=14;
  cout << "nl,nh: " << nl << "," << nh << endl;
  shiftright_till_odd_or_zero(nl,nh);
  cout << "nl,nh: " << nl << "," << nh << endl;
#endif

  long double zahl;
  cout << "Faktorsplitting fr kleine Zahlen (2 unsigned int)" << endl;
  cout << "(Keine Garantie fr Primfaktoren!)" << endl;
  cout << setprecision(20) << "Bitte geben Sie eine Zahl ein: ";
  cin >> zahl;
  nh=zahl/(65536.0*65536.0); nl=zahl-nh*(65536.0*65536.0);
  cout << "eingegebene Zahl: " << show(nl,nh) << endl;
  if (zahl-nh*65536.0*65536.0!=nl)
   {
     cout << "Zahl nicht darstellbar!" << endl;
     return 1;
   }
  uint f=dsuintpollard(nl,nh);
  if (f<2) return 1;
  cout << f << " ist Faktor." << endl;
  zahl/=f;
  nh=zahl/(65536.0*65536.0); nl=zahl-nh*(65536.0*65536.0);
  cout << zahl << " ist Faktor." << endl;
  return 0;
}
