///////////////////////////////////////////////////////////////////////////
// Implementierung:
///////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <math.h>
#include <gmp.h>


void mpz_reciprocal_mod(mpz_t &a, const mpz_t &b, const mpz_t &c)
{
  cout << "--------------------------------------------" << endl;
  mpz_out_str(stdout,10,b); cout << " modulo "; mpz_out_str(stdout,10,c); cout << endl;
  // compute a = b mod c;
  mpz_t h,r; 
  mpz_init(h); mpz_init(r);

  // nachfolgender Block braucht nur bei Initialisierung ausgefhrt werden
  const unsigned int k=mpz_sizeinbase(c,2);
  mpz_set_ui(h,1); mpz_mul_2exp(h,h,2*k);
  mpz_cdiv_q(r,h,c); //mpz_add_ui(r,r,1);
  const unsigned int delta = 0; // k%32;

  cout << "reciprocal: "; mpz_out_str(stdout,10,r); cout << endl;

#if 0
  mpz_fdiv_q_2exp(h,b,k-delta); mpz_mul(h,h,r);
  //mpz_fdiv_q_2exp(h,h,k+delta);
  mpz_fdiv_q_2exp(h,h,k-1+delta); mpz_add_ui(h,h,1); mpz_fdiv_q_2exp(h,h,1);
#endif

#if 0
  // ? b eventuell soweit runtershiften, da ld b = k ?
  unsigned int l = mpz_sizeinbase(b,2);
  unsigned int l1,l2;
  if (l<=k) { l1=0; l2=2*k; } else { l1=0; l2=2*k; }

  mpz_fdiv_q_2exp(h,b,l1);
  mpz_mul(h,h,r);
  mpz_fdiv_q_2exp(h,h,l2);
  //mpz_fdiv_q_2exp(h,h,k-1); mpz_add_ui(h,h,1); mpz_fdiv_q_2exp(h,h,1);
#endif

  mpz_fdiv_q_2exp(h,b,k-1); mpz_add_ui(h,h,1);
  mpz_mul(h,h,r);
  mpz_fdiv_q_2exp(h,h,k+1);

  cout << "b/c: "; mpz_out_str(stdout,10,h); cout << endl;

#if 1
  mpz_t x; mpz_init(x);
  mpz_div(x,b,c);  cout << "b/c (div): "; mpz_out_str(stdout,10,x); cout << endl;
  mpz_mod(x,b,c);  cout << "b%c (mod): "; mpz_out_str(stdout,10,x); cout << endl;
#endif

  mpz_mul(h,h,c); 
  mpz_sub(a,b,h);

  cout << "b%c: "; mpz_out_str(stdout,10,a); cout << endl;
  
  if (mpz_cmp(x,a))
   {
     cerr << "Keine bereinstimmung!" << endl; 
     char c; cin >> c;
   }

}


#if 1
int main()
{
  mpz_t a, b, c;
  mpz_init(a); mpz_init(b); mpz_init(c);

  const int n=21;
  const int nq=n*n;
  mpz_set_ui(c,n);

  for (int i=0; i<nq; ++i)
   {
     mpz_set_si(b,i);
     mpz_reciprocal_mod(a,b,c);
   }
}
#endif
