#!/bin/bash
prg=qsieve

# check, whether fermat-factoring method works
$prg "(p(37^50))*(p(130*37^50+12^30))"
# (disabled, because fermat-method has been shortened)
#$prg "(p(37^50))*(p(190*37^50+12^30))"

# check, whether multiple occurrence of factor is handles correctly 
$prg "P6008*1432919923002337691^3"
$prg "(P6008)^2*1432919923002337691^3"
$prg "(P6008)^2/1432919923002337691"

# does k-th-root and pollard-rho work correctly?
$prg "1792507^10*(p(10^9)^21)*10^20"
$prg "1792507^10*(p(10^9)^22)*10^20"

# trivial factor in phi
$prg F726

# composite factor found by ecm
$prg F744

# handling boundled composite factors in phi/fib
$prg 97415813466381445596089^10*97420733208491869044199^12*55633723511209
