#!/bin/bash
#written by Thorsten Reinecke and Frank Heyder
SERVER=$1
DIR=/tmpfs/qsieve-2.93
CLIENT=$DIR/net-client

REMOTE="ssh -f"

# start client on server?
ONSERVER=yes

# start client with nice? nice-level?
DONICE=yes
NICELEVEL=17

# start clients on following hosts
HOSTLIST="tripper"


if [ x$DONICE == xyes ]; then
  NICE="nice -$NICELEVEL"
else
  NICE=
fi


if xset q &>/dev/null; then
  HASX=yes
else
  HASX=no
fi


# Due to different architectures we assume the following:
# - $DIR is accessible on every host in the network. 
#   (otherwise net-client has to be started manually)
# - if any host needs a different binary version of net-client (and
#   $DIR is shared in the network), then the host should execute it's own
#   binary version called net-client@[hostname].
# - When neccesary, do the following:
#   simply compile net-client and rename net-client to net-client@[hostname]
#   for each host who needs its own binary version. Don't forget to make
#   appropriate changes to the makefile!
#   After finishing this procedure simply compile the standard binaries
#   again for all the other hosts.
#   (Doing this, you can also use optimized versions of GNU MP!)

for host in $HOSTLIST
do
  if [ x$HASX == xyes ]; then
   XTERM="xterm -geometry +0+0 -T $host -e"
  else
   XTERM=
  fi

  if [ -x $CLIENT@$host ]; then
   myCLIENT=$CLIENT@$host
  else
   myCLIENT=$CLIENT
  fi

  if [ x$SERVER == x$host ]; then
    if [ "$ONSERVER" == "yes" ]; then
      rm -f /tmp/qsieve-*
      echo calling $myCLIENT for $host
      $XTERM $NICE $myCLIENT $SERVER &>/dev/null &
    fi
  else
    echo calling $myCLIENT for $host
    if isalive $host; then
      $REMOTE $host rm -f "/tmp/qsieve-*"
      $XTERM $REMOTE $host $NICE $myCLIENT $SERVER &>/dev/null &
    else
     echo "Can't connect host $host"
    fi
  fi
done
